/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.processor.update;

import com.nhl.link.rest.EntityParent;
import com.nhl.link.rest.EntityUpdate;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrPersistentRelationship;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.processor.Processor;
import com.nhl.link.rest.processor.ProcessorOutcome;
import com.nhl.link.rest.runtime.constraints.IConstraintsHandler;
import com.nhl.link.rest.runtime.encoder.IEncoderService;
import com.nhl.link.rest.runtime.meta.IMetadataService;
import com.nhl.link.rest.runtime.processor.update.UpdateContext;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.di.Inject;

public class ApplyServerParamsStage
implements Processor<UpdateContext<?>> {
    private IEncoderService encoderService;
    private IConstraintsHandler constraintsHandler;
    private IMetadataService metadataService;

    public ApplyServerParamsStage(@Inject IEncoderService encoderService, @Inject IConstraintsHandler constraintsHandler, @Inject IMetadataService metadataService) {
        this.encoderService = encoderService;
        this.constraintsHandler = constraintsHandler;
        this.metadataService = metadataService;
    }

    @Override
    public ProcessorOutcome execute(UpdateContext<?> context) {
        this.doExecute(context);
        return ProcessorOutcome.CONTINUE;
    }

    protected <T> void doExecute(UpdateContext<T> context) {
        ResourceEntity<T> entity = context.getEntity();
        this.processExplicitId(context);
        this.processParentId(context);
        this.constraintsHandler.constrainUpdate(context, context.getWriteConstraints());
        this.constraintsHandler.constrainResponse(entity, null, context.getReadConstraints());
        context.setEncoder(this.encoderService.dataEncoder(entity));
    }

    private <T> void processExplicitId(UpdateContext<T> context) {
        if (context.isById()) {
            if (context.getUpdates().isEmpty()) {
                context.setUpdates(Collections.singleton(new EntityUpdate<T>(context.getEntity().getLrEntity())));
            }
            LrEntity<T> entity = context.getEntity().getLrEntity();
            EntityUpdate<T> u = context.getFirst();
            Map<String, Object> idMap = u.getOrCreateId();
            idMap.putAll(context.getId().asMap(entity));
            u.setExplicitId();
        }
    }

    private <T> void processParentId(UpdateContext<T> context) {
        LrPersistentRelationship r;
        LrRelationship fromParent;
        EntityParent<?> parent = context.getParent();
        if (parent != null && parent.getId() != null && (fromParent = this.relationshipFromParent(context)) instanceof LrPersistentRelationship && (r = (LrPersistentRelationship)fromParent).isToDependentEntity()) {
            for (EntityUpdate<T> u : context.getUpdates()) {
                u.getOrCreateId().putAll(r.extractId(parent.getId()));
            }
        }
    }

    private LrRelationship relationshipFromParent(UpdateContext<?> context) {
        EntityParent<?> parent = context.getParent();
        if (parent == null) {
            return null;
        }
        LrRelationship r = this.metadataService.getLrRelationship(parent);
        if (r instanceof LrPersistentRelationship) {
            return r;
        }
        return null;
    }
}

