/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.processor.select;

import com.nhl.link.rest.CompoundObjectId;
import com.nhl.link.rest.DataResponse;
import com.nhl.link.rest.EntityParent;
import com.nhl.link.rest.EntityProperty;
import com.nhl.link.rest.LrObjectId;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.SimpleObjectId;
import com.nhl.link.rest.SizeConstraints;
import com.nhl.link.rest.constraints.Constraint;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.processor.BaseProcessingContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.apache.cayenne.query.SelectQuery;

public class SelectContext<T>
extends BaseProcessingContext<T> {
    private LrObjectId id;
    private EntityParent<?> parent;
    private ResourceEntity<T> entity;
    private UriInfo uriInfo;
    private String autocompleteProperty;
    private Map<String, EntityProperty> extraProperties;
    private SizeConstraints sizeConstraints;
    private Constraint<T> constraint;
    private boolean atMostOneObject;
    private Encoder encoder;
    private int prefetchSemantics;
    private List objects;
    private SelectQuery<T> select;

    public SelectContext(Class<T> type) {
        super(type);
    }

    public DataResponse<T> createDataResponse() {
        List objects = this.objects != null ? this.objects : Collections.emptyList();
        DataResponse response = DataResponse.forType(this.getType());
        response.setObjects(objects);
        response.setEncoder(this.encoder);
        response.setStatus(this.getStatus());
        return response;
    }

    public boolean isById() {
        return this.id != null;
    }

    public LrObjectId getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = new SimpleObjectId(id);
    }

    public void setCompoundId(Map<String, Object> ids) {
        this.id = new CompoundObjectId(ids);
    }

    public EntityParent<?> getParent() {
        return this.parent;
    }

    public void setParent(EntityParent<?> parent) {
        this.parent = parent;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public Map<String, List<String>> getProtocolParameters() {
        return this.uriInfo != null ? this.uriInfo.getQueryParameters() : Collections.emptyMap();
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public String getAutocompleteProperty() {
        return this.autocompleteProperty;
    }

    public void setAutocompleteProperty(String autocompleteProperty) {
        this.autocompleteProperty = autocompleteProperty;
    }

    public Map<String, EntityProperty> getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Map<String, EntityProperty> extraProperties) {
        this.extraProperties = extraProperties;
    }

    public SizeConstraints getSizeConstraints() {
        return this.sizeConstraints;
    }

    public void setSizeConstraints(SizeConstraints sizeConstraints) {
        this.sizeConstraints = sizeConstraints;
    }

    public Constraint<T> getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Constraint<T> constraint) {
        this.constraint = constraint;
    }

    public SelectQuery<T> getSelect() {
        return this.select;
    }

    public void setSelect(SelectQuery<T> select) {
        this.select = select;
    }

    public boolean isAtMostOneObject() {
        return this.atMostOneObject;
    }

    public void setAtMostOneObject(boolean expectingOne) {
        this.atMostOneObject = expectingOne;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public ResourceEntity<T> getEntity() {
        return this.entity;
    }

    public void setEntity(ResourceEntity<T> entity) {
        this.entity = entity;
    }

    public int getPrefetchSemantics() {
        return this.prefetchSemantics;
    }

    public void setPrefetchSemantics(int prefetchSemantics) {
        this.prefetchSemantics = prefetchSemantics;
    }

    public List<T> getObjects() {
        return this.objects;
    }

    public void setObjects(List<? extends T> objects) {
        this.objects = objects;
    }
}

