/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.processor.select;

import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.encoder.EncoderFilter;
import com.nhl.link.rest.processor.Processor;
import com.nhl.link.rest.processor.ProcessorOutcome;
import com.nhl.link.rest.runtime.constraints.IConstraintsHandler;
import com.nhl.link.rest.runtime.encoder.IEncoderService;
import com.nhl.link.rest.runtime.processor.select.SelectContext;
import java.util.List;
import org.apache.cayenne.di.Inject;

public class ApplyServerParamsStage
implements Processor<SelectContext<?>> {
    private IConstraintsHandler constraintsHandler;
    private IEncoderService encoderService;
    private List<EncoderFilter> filters;

    public ApplyServerParamsStage(@Inject IConstraintsHandler constraintsHandler, @Inject IEncoderService encoderService, @Inject List<EncoderFilter> filters) {
        this.constraintsHandler = constraintsHandler;
        this.encoderService = encoderService;
        this.filters = filters;
    }

    @Override
    public ProcessorOutcome execute(SelectContext<?> context) {
        this.doExecute(context);
        return ProcessorOutcome.CONTINUE;
    }

    protected <T> void doExecute(SelectContext<T> context) {
        ResourceEntity<T> entity = context.getEntity();
        this.constraintsHandler.constrainResponse(entity, context.getSizeConstraints(), context.getConstraint());
        if (context.getExtraProperties() != null) {
            entity.getExtraProperties().putAll(context.getExtraProperties());
        }
        for (EncoderFilter filter : this.filters) {
            if (!filter.matches(entity)) continue;
            entity.setFiltered(true);
            break;
        }
        if (context.getEncoder() == null) {
            context.setEncoder(this.encoderService.dataEncoder(entity));
        }
    }
}

