/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.processor.meta;

import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrResource;
import com.nhl.link.rest.processor.Processor;
import com.nhl.link.rest.processor.ProcessorOutcome;
import com.nhl.link.rest.runtime.encoder.IEncoderService;
import com.nhl.link.rest.runtime.meta.IMetadataService;
import com.nhl.link.rest.runtime.meta.IResourceMetadataService;
import com.nhl.link.rest.runtime.processor.meta.MetadataContext;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cayenne.di.Inject;

public class CollectMetadataStage
implements Processor<MetadataContext<?>> {
    private IMetadataService metadataService;
    private IResourceMetadataService resourceMetadataService;
    private IEncoderService encoderService;

    public CollectMetadataStage(@Inject IMetadataService metadataService, @Inject IResourceMetadataService resourceMetadataService, @Inject IEncoderService encoderService) {
        this.metadataService = metadataService;
        this.resourceMetadataService = resourceMetadataService;
        this.encoderService = encoderService;
    }

    @Override
    public ProcessorOutcome execute(MetadataContext<?> context) {
        this.doExecute(context);
        return ProcessorOutcome.CONTINUE;
    }

    protected <T> void doExecute(MetadataContext<T> context) {
        LrEntity entity = this.metadataService.getLrEntity(context.getType());
        Collection<LrResource<?>> resources = this.resourceMetadataService.getLrResources(context.getResource());
        ArrayList filteredResources = new ArrayList(resources.size());
        for (LrResource<?> resource : resources) {
            LrEntity<?> resourceEntity = resource.getEntity();
            if (resourceEntity == null || !resourceEntity.getName().equals(entity.getName())) continue;
            filteredResources.add(resource);
        }
        ResourceEntity resourceEntity = new ResourceEntity(entity);
        resourceEntity.setApplicationBase(context.getApplicationBase());
        context.setResources(filteredResources);
        context.setEncoder(this.encoderService.metadataEncoder(resourceEntity));
    }
}

