/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.runtime.jackson.IJacksonService;
import com.nhl.link.rest.runtime.parser.filter.ICayenneExpProcessor;
import com.nhl.link.rest.runtime.parser.sort.ISortProcessor;
import com.nhl.link.rest.runtime.parser.tree.ExcludeWorker;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.cayenne.exp.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludeWorker.class);
    private static final String PATH = "path";
    private static final String MAP_BY = "mapBy";
    private static final String SORT = "sort";
    private static final String CAYENNE_EXP = "cayenneExp";
    private static final String START = "start";
    private static final String LIMIT = "limit";
    private IJacksonService jsonParser;
    private ISortProcessor sortProcessor;
    private ICayenneExpProcessor expProcessor;

    public IncludeWorker(IJacksonService jsonParser, ISortProcessor sortProcessor, ICayenneExpProcessor expProcessor) {
        this.jsonParser = jsonParser;
        this.sortProcessor = sortProcessor;
        this.expProcessor = expProcessor;
    }

    public void process(ResourceEntity<?> resourceEntity, List<String> includes) {
        for (String include : includes) {
            if (include.startsWith("[")) {
                this.processIncludeArray(resourceEntity, include);
                continue;
            }
            if (include.startsWith("{")) {
                JsonNode root = this.jsonParser.parseJson(include);
                this.processIncludeObject(resourceEntity, root);
                continue;
            }
            IncludeWorker.processIncludePath(resourceEntity, include);
        }
        IncludeWorker.processDefaultIncludes(resourceEntity);
    }

    private void processIncludeArray(ResourceEntity<?> resourceEntity, String include) {
        JsonNode root = this.jsonParser.parseJson(include);
        if (root != null && root.isArray()) {
            for (JsonNode child : root) {
                if (child.isObject()) {
                    this.processIncludeObject(resourceEntity, child);
                    continue;
                }
                if (child.isTextual()) {
                    IncludeWorker.processIncludePath(resourceEntity, child.asText());
                    continue;
                }
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Bad include spec: " + child);
            }
        }
    }

    private void processIncludeObject(ResourceEntity<?> rootEntity, JsonNode root) {
        if (root != null) {
            JsonNode limitNode;
            JsonNode startNode;
            Expression exp;
            JsonNode expNode;
            JsonNode sortNode;
            ResourceEntity<?> includeEntity;
            JsonNode pathNode = root.get(PATH);
            if (pathNode == null || !pathNode.isTextual()) {
                includeEntity = rootEntity;
            } else {
                String path = pathNode.asText();
                includeEntity = IncludeWorker.processIncludePath(rootEntity, path);
                if (includeEntity == null) {
                    throw new LinkRestException(Response.Status.BAD_REQUEST, "Bad include spec, non-relationship 'path' in include object: " + path);
                }
            }
            JsonNode mapByNode = root.get(MAP_BY);
            if (mapByNode != null) {
                if (!mapByNode.isTextual()) {
                    throw new LinkRestException(Response.Status.BAD_REQUEST, "Bad include spec - invalid 'mapBy': " + root);
                }
                this.processMapBy(includeEntity, mapByNode.asText());
            }
            if ((sortNode = root.get(SORT)) != null) {
                this.sortProcessor.process(includeEntity, sortNode);
            }
            if ((expNode = root.get(CAYENNE_EXP)) != null && (exp = this.expProcessor.process(includeEntity.getLrEntity(), expNode)) != null) {
                includeEntity.andQualifier(exp);
            }
            if ((startNode = root.get(START)) != null) {
                includeEntity.setFetchOffset(startNode.asInt());
            }
            if ((limitNode = root.get(LIMIT)) != null) {
                includeEntity.setFetchLimit(limitNode.asInt());
            }
        }
    }

    private <T> void processMapBy(ResourceEntity<T> descriptor, String mapByPath) {
        if (descriptor == null) {
            LOGGER.info("Ignoring 'mapBy:" + mapByPath + "' for non-relationship property");
            return;
        }
        if (descriptor.getIncoming() == null || descriptor.getIncoming().isToMany()) {
            ResourceEntity<T> mapByRoot = new ResourceEntity<T>(descriptor.getLrEntity());
            IncludeWorker.processIncludePath(mapByRoot, mapByPath);
            descriptor.mapBy(mapByRoot, mapByPath);
        } else {
            LOGGER.info("Ignoring 'mapBy:" + mapByPath + "' for to-one relationship property");
        }
    }

    public static ResourceEntity<?> processIncludePath(ResourceEntity<?> parent, String path) {
        ExcludeWorker.checkTooLong(path);
        int dot = path.indexOf(46);
        if (dot == 0) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Include starts with dot: " + path);
        }
        if (dot == path.length() - 1) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Include ends with dot: " + path);
        }
        String property = dot > 0 ? path.substring(0, dot) : path;
        LrEntity<?> lrEntity = parent.getLrEntity();
        LrAttribute attribute = lrEntity.getAttribute(property);
        if (attribute != null) {
            if (dot > 0) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid include path: " + path);
            }
            parent.getAttributes().put(property, attribute);
            return null;
        }
        LrRelationship relationship = lrEntity.getRelationship(property);
        if (relationship != null) {
            ResourceEntity<?> childEntity = parent.getChild(property);
            if (childEntity == null) {
                LrEntity<?> targetType = relationship.getTargetEntity();
                childEntity = new ResourceEntity(targetType, relationship);
                parent.getChildren().put(property, childEntity);
            }
            if (dot > 0) {
                return IncludeWorker.processIncludePath(childEntity, path.substring(dot + 1));
            }
            IncludeWorker.processDefaultIncludes(childEntity);
            childEntity.includeId();
            return childEntity;
        }
        if (property.equals("id")) {
            parent.includeId();
            return null;
        }
        throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid include path: " + path);
    }

    private static void processDefaultIncludes(ResourceEntity<?> resourceEntity) {
        if (!resourceEntity.isIdIncluded() && resourceEntity.getAttributes().isEmpty()) {
            for (LrAttribute a : resourceEntity.getLrEntity().getAttributes()) {
                resourceEntity.getAttributes().put(a.getName(), a);
                resourceEntity.getDefaultProperties().add(a.getName());
            }
            resourceEntity.includeId();
        }
    }
}

