/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.runtime.jackson.IJacksonService;
import java.util.List;
import javax.ws.rs.core.Response;

public class ExcludeWorker {
    private IJacksonService jsonParser;

    public ExcludeWorker(IJacksonService jsonParser) {
        this.jsonParser = jsonParser;
    }

    static void checkTooLong(String path) {
        if (path != null && path.length() > 300) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Include/exclude path too long: " + path);
        }
    }

    public void process(ResourceEntity<?> resourceEntity, List<String> excludes) {
        for (String exclude : excludes) {
            if (exclude.startsWith("[")) {
                this.processExcludeArray(resourceEntity, exclude);
                continue;
            }
            this.processExcludePath(resourceEntity, exclude);
        }
    }

    private void processExcludeArray(ResourceEntity<?> resourceEntity, String exclude) {
        JsonNode root = this.jsonParser.parseJson(exclude);
        if (root != null && root.isArray()) {
            for (JsonNode child : root) {
                if (child.isTextual()) {
                    this.processExcludePath(resourceEntity, child.asText());
                    continue;
                }
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Bad exclude spec: " + child);
            }
        }
    }

    void processExcludePath(ResourceEntity<?> resourceEntity, String path) {
        String property;
        ExcludeWorker.checkTooLong(path);
        int dot = path.indexOf(46);
        if (dot == 0) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Exclude starts with dot: " + path);
        }
        if (dot == path.length() - 1) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Exclude ends with dot: " + path);
        }
        String string = property = dot > 0 ? path.substring(0, dot) : path;
        if (resourceEntity.getLrEntity().getAttribute(property) != null) {
            if (dot > 0) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid exclude path: " + path);
            }
            resourceEntity.getAttributes().remove(property);
            return;
        }
        if (resourceEntity.getLrEntity().getRelationship(property) != null) {
            ResourceEntity<?> relatedFilter = resourceEntity.getChild(property);
            if (relatedFilter == null) {
                return;
            }
            if (dot > 0) {
                this.processExcludePath(relatedFilter, path.substring(dot + 1));
            }
            return;
        }
        if (property.equals("id")) {
            resourceEntity.excludeId();
            return;
        }
        throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid exclude path: " + path);
    }
}

