/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.sort;

import com.fasterxml.jackson.databind.JsonNode;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.runtime.jackson.IJacksonService;
import com.nhl.link.rest.runtime.parser.BaseRequestProcessor;
import com.nhl.link.rest.runtime.parser.cache.IPathCache;
import com.nhl.link.rest.runtime.parser.sort.ISortProcessor;
import com.nhl.link.rest.runtime.parser.sort.SortWorker;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.di.Inject;

public class SortProcessor
extends BaseRequestProcessor
implements ISortProcessor {
    private static final String SORT = "sort";
    private static final String DIR = "dir";
    private SortWorker worker;

    public SortProcessor(@Inject IJacksonService jacksonService, @Inject IPathCache pathCache) {
        this.worker = new SortWorker(jacksonService, pathCache);
    }

    @Override
    public void process(ResourceEntity<?> entity, Map<String, List<String>> protocolParameters) {
        this.process(entity, SortProcessor.string(protocolParameters, SORT), SortProcessor.string(protocolParameters, DIR));
    }

    protected void process(ResourceEntity<?> resourceEntity, String sort, String direction) {
        this.worker.process(resourceEntity, sort, direction);
    }

    @Override
    public void process(ResourceEntity<?> entity, JsonNode sortNode) {
        if (sortNode.isTextual()) {
            this.worker.process(entity, sortNode.asText(), null);
        } else {
            this.worker.processSorterArray(entity, sortNode);
        }
    }
}

