/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.pointer;

import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.runtime.parser.pointer.LrPointer;
import com.nhl.link.rest.runtime.parser.pointer.PointerContext;
import com.nhl.link.rest.runtime.parser.pointer.Pointers;

abstract class SimplePointer
implements LrPointer {
    private SimplePointer predecessor;
    private LrEntity<?> entity;

    SimplePointer(SimplePointer predecessor, LrEntity<?> entity) {
        this.predecessor = predecessor;
        this.entity = entity;
    }

    @Override
    public final Class<?> getBaseType() {
        return this.predecessor == null ? this.entity.getType() : this.predecessor.getBaseType();
    }

    @Override
    public LrPointer getParent() {
        return this.predecessor;
    }

    @Override
    public final Object resolve(PointerContext context, Object baseObject) throws Exception {
        if (context == null) {
            throw new IllegalStateException("Null context in pointer: " + this.toString());
        }
        if (this.predecessor != null) {
            baseObject = this.predecessor.resolve(context, baseObject);
        }
        return this.doResolve(context, baseObject);
    }

    @Override
    public final Object resolve(PointerContext context) throws Exception {
        return this.resolve(context, null);
    }

    protected abstract Object doResolve(PointerContext var1, Object var2);

    protected abstract String encodeToString();

    public final String toString() {
        return this.predecessor == null ? this.encodeToString() : Pointers.buildPath(this.predecessor.encodeToString(), this.encodeToString());
    }
}

