/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.pointer;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.runtime.parser.pointer.PointerContext;
import com.nhl.link.rest.runtime.parser.pointer.PointerType;
import com.nhl.link.rest.runtime.parser.pointer.Pointers;
import com.nhl.link.rest.runtime.parser.pointer.SimplePointer;
import javax.ws.rs.core.Response;

class RelationshipPointer
extends SimplePointer {
    private PointerType type;
    private LrRelationship relationship;
    private Object id;

    RelationshipPointer(SimplePointer predecessor, LrEntity<?> entity, LrRelationship relationship, Object id) {
        super(predecessor, entity);
        this.relationship = relationship;
        this.id = id;
        this.type = relationship.isToMany() ? PointerType.TO_MANY_RELATIONSHIP : (id != null ? PointerType.EXPLICIT_TO_ONE_RELATIONSHIP : PointerType.IMPLICIT_TO_ONE_RELATIONSHIP);
    }

    @Override
    protected Object doResolve(PointerContext context, Object baseObject) {
        if (baseObject == null) {
            throw new IllegalArgumentException("Null base object passed to pointer: " + this.toString());
        }
        switch (this.type) {
            case IMPLICIT_TO_ONE_RELATIONSHIP: {
                return context.resolveProperty(baseObject, this.relationship.getName());
            }
            case EXPLICIT_TO_ONE_RELATIONSHIP: 
            case TO_MANY_RELATIONSHIP: {
                return context.resolveObject(this.getTargetType(), this.id);
            }
        }
        throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Unknown pointer type: " + this.getType().name());
    }

    @Override
    protected String encodeToString() {
        String encoded;
        switch (this.type) {
            case EXPLICIT_TO_ONE_RELATIONSHIP: 
            case TO_MANY_RELATIONSHIP: {
                encoded = Pointers.buildRelationship(this.relationship.getName(), this.id);
                break;
            }
            case IMPLICIT_TO_ONE_RELATIONSHIP: {
                encoded = this.relationship.getName();
                break;
            }
            default: {
                throw new RuntimeException("Unknown pointer type: " + this.type.name());
            }
        }
        return encoded;
    }

    @Override
    public PointerType getType() {
        return this.type;
    }

    @Override
    public Class<?> getTargetType() {
        return this.relationship.getTargetEntity().getType();
    }

    LrRelationship getRelationship() {
        return this.relationship;
    }

    Object getId() {
        return this.id;
    }
}

