/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.pointer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.runtime.parser.pointer.LrPointer;
import com.nhl.link.rest.runtime.parser.pointer.LrPointerBuilder;
import com.nhl.link.rest.runtime.parser.pointer.LrPointerService;
import com.nhl.link.rest.runtime.parser.pointer.Pointers;
import java.util.StringTokenizer;
import javax.ws.rs.core.Response;

public class PointerParser {
    private static final String JSON_POINTER_PROPERTY_ATTRIBUTE = "property";
    private static final String JSON_POINTER_ID_ATTRIBUTE = "id";
    private LrPointerService pointerService;

    public PointerParser(LrPointerService pointerService) {
        this.pointerService = pointerService;
    }

    public LrPointer getPointer(LrEntity<?> rootEntity, JsonNode node) {
        if (node == null) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid empty pointer for '" + rootEntity.getName() + "'");
        }
        LrPointerService.DefaultLrPointerBuilder builder = this.pointerService.forEntity(rootEntity);
        try {
            if (node.isArray()) {
                ArrayNode pointerNodes = (ArrayNode)node;
                if (pointerNodes.size() == 0) {
                    throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid empty pointer for '" + rootEntity.getName() + "'");
                }
                for (JsonNode pointerNode : pointerNodes) {
                    this.appendSimplePointer(builder, pointerNode);
                }
            } else {
                this.appendSimplePointer(builder, node);
            }
        }
        catch (Exception e) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid pointer '" + node.toString() + "' for '" + rootEntity.getName() + "'", e);
        }
        return builder.build();
    }

    private void appendSimplePointer(LrPointerBuilder builder, JsonNode pointerNode) throws Exception {
        if (!pointerNode.isObject()) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid pointer element '" + pointerNode.toString() + "'");
        }
        JsonNode propertyNode = pointerNode.get(JSON_POINTER_PROPERTY_ATTRIBUTE);
        JsonNode idNode = pointerNode.get(JSON_POINTER_ID_ATTRIBUTE);
        if (propertyNode == null && idNode == null) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid pointer element '" + pointerNode.toString() + "'");
        }
        if (propertyNode == null) {
            builder.append(idNode.textValue());
        } else if (idNode == null) {
            builder.append(propertyNode.textValue());
        } else {
            builder.append(propertyNode.textValue(), idNode.textValue());
        }
    }

    public LrPointer getPointer(LrEntity<?> rootEntity, String s) {
        if (s == null || s.isEmpty()) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid empty pointer for '" + rootEntity.getName() + "'");
        }
        if (s.startsWith(".") || s.startsWith(":") || s.endsWith(".") || s.endsWith(":")) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid pointer '" + s + "' for '" + rootEntity.getName() + "'");
        }
        LrPointerService.DefaultLrPointerBuilder builder = this.pointerService.forEntity(rootEntity);
        StringTokenizer properties = new StringTokenizer(Pointers.unescape(s), ".");
        while (properties.hasMoreTokens()) {
            String property = properties.nextToken();
            if (property.isEmpty()) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid pointer '" + s + "' for '" + rootEntity.getName() + "'");
            }
            if (property.startsWith(":") || property.endsWith(":")) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid pointer '" + s + "' for '" + rootEntity.getName() + "'");
            }
            String[] parts = property.split(":");
            if (parts.length == 1) {
                builder.append(parts[0]);
                continue;
            }
            if (parts.length == 2) {
                builder.append(parts[0], parts[1]);
                continue;
            }
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid pointer '" + s + "' for '" + rootEntity.getName() + "'");
        }
        return builder.build();
    }
}

