/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.pointer;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.runtime.parser.pointer.AttributePointer;
import com.nhl.link.rest.runtime.parser.pointer.LrPointer;
import com.nhl.link.rest.runtime.parser.pointer.LrPointerBuilder;
import com.nhl.link.rest.runtime.parser.pointer.ObjectInstancePointer;
import com.nhl.link.rest.runtime.parser.pointer.PointerType;
import com.nhl.link.rest.runtime.parser.pointer.RelationshipPointer;
import com.nhl.link.rest.runtime.parser.pointer.SimplePointer;
import javax.ws.rs.core.Response;

public class LrPointerService {
    DefaultLrPointerBuilder forEntity(LrEntity<?> entity) {
        return new DefaultLrPointerBuilder(entity);
    }

    private class DefaultLrPointerBuilder
    implements LrPointerBuilder {
        private LrEntity<?> currentEntity;
        private SimplePointer tail;

        private DefaultLrPointerBuilder(LrEntity<?> entity) {
            this.currentEntity = entity;
        }

        @Override
        public DefaultLrPointerBuilder append(String relationshipName, Object id) {
            this.ensurePossibleToAddMoreElements();
            LrRelationship relationship = this.currentEntity.getRelationship(relationshipName);
            if (relationship == null) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Unknown relationship '" + relationshipName + "' for '" + this.currentEntity.getName() + "'");
            }
            this.tail = new RelationshipPointer(this.tail, this.currentEntity, relationship, id);
            this.currentEntity = relationship.getTargetEntity();
            return this;
        }

        @Override
        public DefaultLrPointerBuilder append(String pathElement) {
            this.ensurePossibleToAddMoreElements();
            LrAttribute attribute = this.currentEntity.getAttribute(pathElement);
            if (attribute != null) {
                this.tail = new AttributePointer(this.tail, this.currentEntity, attribute);
            } else {
                LrRelationship relationship = this.currentEntity.getRelationship(pathElement);
                if (relationship != null) {
                    if (relationship.isToMany()) {
                        throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid pointer element: to-many relationship '" + pathElement + "' without explicit ID");
                    }
                    this.tail = new RelationshipPointer(this.tail, this.currentEntity, relationship, null);
                    this.currentEntity = relationship.getTargetEntity();
                } else {
                    this.tail = new ObjectInstancePointer(this.tail, this.currentEntity, pathElement);
                }
            }
            return this;
        }

        private void ensurePossibleToAddMoreElements() {
            PointerType type;
            if (this.tail != null && (type = this.tail.getType()) == PointerType.ATTRIBUTE) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Can't add pointer element: last element was attribute");
            }
        }

        @Override
        public LrPointer build() {
            if (this.tail == null) {
                throw new IllegalStateException("Can't build an empty pointer");
            }
            return this.tail;
        }
    }
}

