/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.pointer;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.runtime.cayenne.ICayennePersister;
import com.nhl.link.rest.runtime.parser.pointer.LrPointer;
import com.nhl.link.rest.runtime.parser.pointer.ObjectInstancePointer;
import com.nhl.link.rest.runtime.parser.pointer.PointerContext;
import com.nhl.link.rest.runtime.parser.pointer.RelationshipPointer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.query.SelectById;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.reflect.PropertyDescriptor;

public class CayennePointerContext
implements PointerContext {
    private ICayennePersister cayenneService;
    private ObjectContext delegateContext;
    private final Map<Class<?>, List<?>> objectStore;

    CayennePointerContext(ICayennePersister cayenneService, List<? extends LrPointer> pointers) {
        this.cayenneService = cayenneService;
        Map<Class<?>, SelectQuery<?>> queries = this.getQueries(pointers);
        this.objectStore = new HashMap((int)((double)queries.size() / 0.75));
        ObjectContext context = cayenneService.newContext();
        for (Map.Entry<Class<?>, SelectQuery<?>> entry : queries.entrySet()) {
            this.objectStore.put(entry.getKey(), context.select((Select)entry.getValue()));
        }
        this.delegateContext = context;
    }

    private Map<Class<?>, SelectQuery<?>> getQueries(List<? extends LrPointer> pointers) {
        HashMap queries = new HashMap(2);
        for (LrPointer lrPointer : pointers) {
            Class<?> baseEntityClass = lrPointer.getBaseType();
            SelectQuery query = (SelectQuery)queries.get(baseEntityClass);
            if (query == null) {
                query = SelectQuery.query(baseEntityClass);
                queries.put(baseEntityClass, query);
            }
            ObjEntity baseEntity = this.cayenneService.entityResolver().getObjEntity(baseEntityClass);
            String currentPath = "";
            List<LrPointer> parts = this.collectParts(lrPointer);
            block6: for (int i = parts.size() - 1; i >= 0; --i) {
                LrPointer part = parts.get(i);
                switch (part.getType()) {
                    case INSTANCE: {
                        if (!baseEntityClass.equals(part.getTargetType())) continue block6;
                        if (baseEntity.getPrimaryKeys().size() > 1) {
                            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Multi-attribute IDs not supported");
                        }
                        query.andQualifier(ExpressionFactory.matchDbExp((String)((String)baseEntity.getPrimaryKeyNames().iterator().next()), (Object)((ObjectInstancePointer)part).getId()));
                        continue block6;
                    }
                    case ATTRIBUTE: {
                        continue block6;
                    }
                    case EXPLICIT_TO_ONE_RELATIONSHIP: 
                    case IMPLICIT_TO_ONE_RELATIONSHIP: 
                    case TO_MANY_RELATIONSHIP: {
                        String relationshipName = ((RelationshipPointer)part).getRelationship().getName();
                        currentPath = currentPath + "." + relationshipName;
                        PrefetchTreeNode prefetch = PrefetchTreeNode.withPath((String)currentPath, (int)1);
                        query.addPrefetch(prefetch);
                        continue block6;
                    }
                    default: {
                        throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Unknown pointer type: " + part.getType().name());
                    }
                }
            }
        }
        return queries;
    }

    private List<LrPointer> collectParts(LrPointer pointer) {
        ArrayList<LrPointer> parts = new ArrayList<LrPointer>();
        LrPointer part = pointer;
        do {
            parts.add(part);
        } while ((part = part.getParent()) != null);
        return parts;
    }

    @Override
    public <T> T resolveObject(Class<T> type, Object id) {
        return (T)SelectById.query(type, (Object)id).selectOne(this.delegateContext);
    }

    @Override
    public Object resolveProperty(Object baseObject, String propertyName) {
        Persistent persistentBaseObject = (Persistent)baseObject;
        ObjEntity entity = this.cayenneService.entityResolver().getObjEntity(persistentBaseObject);
        PropertyDescriptor property = this.cayenneService.entityResolver().getClassDescriptor(entity.getName()).getProperty(propertyName);
        return property.readProperty(baseObject);
    }
}

