/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.pointer;

import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.runtime.parser.pointer.PointerContext;
import com.nhl.link.rest.runtime.parser.pointer.PointerType;
import com.nhl.link.rest.runtime.parser.pointer.SimplePointer;

class AttributePointer
extends SimplePointer {
    private LrAttribute attribute;

    AttributePointer(SimplePointer predecessor, LrEntity<?> entity, LrAttribute attribute) {
        super(predecessor, entity);
        this.attribute = attribute;
    }

    @Override
    protected Object doResolve(PointerContext context, Object baseObject) {
        if (baseObject == null) {
            throw new IllegalArgumentException("Null base object passed to pointer: " + this.toString());
        }
        return context.resolveProperty(baseObject, this.attribute.getName());
    }

    @Override
    protected String encodeToString() {
        return this.attribute.getName();
    }

    @Override
    public PointerType getType() {
        return PointerType.ATTRIBUTE;
    }

    @Override
    public Class<?> getTargetType() {
        return this.attribute.getType();
    }

    LrAttribute getAttribute() {
        return this.attribute;
    }
}

