/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.filter;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.runtime.parser.filter.FilterUtil;
import com.nhl.link.rest.runtime.parser.filter.IKeyValueExpProcessor;
import javax.ws.rs.core.Response;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;

public class KeyValueExpProcessor
implements IKeyValueExpProcessor {
    @Override
    public Expression process(LrEntity<?> entity, String queryProperty, String value) {
        if (value == null || value.length() == 0 || queryProperty == null) {
            return null;
        }
        this.validateAttribute(entity, queryProperty);
        value = FilterUtil.escapeValueForLike(value) + "%";
        return ExpressionFactory.likeIgnoreCaseExp((String)queryProperty, (Object)value);
    }

    private void validateAttribute(LrEntity<?> entity, String queryProperty) {
        LrAttribute attribute = entity.getAttribute(queryProperty);
        if (attribute == null) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "No such property '" + queryProperty + "' for entity '" + entity.getName() + "'");
        }
        if (!String.class.equals(attribute.getType())) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Invalid property type for query comparison: '" + queryProperty + "' for entity '" + entity.getName() + "'");
        }
    }
}

