/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.parser.converter.JsonValueConverter;
import com.nhl.link.rest.parser.converter.UtcDateConverter;
import com.nhl.link.rest.runtime.parser.cache.IPathCache;
import com.nhl.link.rest.runtime.parser.cache.PathDescriptor;
import com.nhl.link.rest.runtime.parser.filter.IExpressionPostProcessor;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.TraversalHandler;
import org.apache.cayenne.exp.TraversalHelper;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.parser.ConditionNode;
import org.apache.cayenne.exp.parser.SimpleNode;

public class ExpressionPostProcessor
implements IExpressionPostProcessor {
    private IPathCache pathCache;
    private Map<Class<?>, JsonValueConverter> converters;
    private Map<LrEntity<?>, ExpressionProcessor> postProcessors;

    public ExpressionPostProcessor(@Inject IPathCache pathCache) {
        this.pathCache = pathCache;
        HashMap converters = new HashMap();
        converters.put(java.util.Date.class, UtcDateConverter.converter());
        converters.put(Date.class, UtcDateConverter.converter());
        converters.put(Time.class, UtcDateConverter.converter());
        converters.put(Timestamp.class, UtcDateConverter.converter());
        this.converters = converters;
        this.postProcessors = new ConcurrentHashMap();
    }

    @Override
    public Expression process(LrEntity<?> entity, Expression exp) {
        return exp == null ? null : this.validateAndCleanup(entity, exp);
    }

    private Expression validateAndCleanup(LrEntity<?> entity, Expression exp) {
        exp.traverse((TraversalHandler)this.getOrCreateExpressionProcessor(entity));
        if (exp instanceof ASTObjPath) {
            exp = this.pathCache.getPathDescriptor(entity, (ASTObjPath)exp).getPathExp();
        }
        return exp;
    }

    private ExpressionProcessor getOrCreateExpressionProcessor(LrEntity<?> entity) {
        ExpressionProcessor existing;
        ExpressionProcessor postProcessor = this.postProcessors.get(entity);
        if (postProcessor == null && (existing = this.postProcessors.putIfAbsent(entity, postProcessor = new ExpressionProcessor(entity))) != null) {
            postProcessor = existing;
        }
        return postProcessor;
    }

    private class ExpressionProcessor
    extends TraversalHelper {
        private LrEntity<?> entity;

        ExpressionProcessor(LrEntity<?> entity) {
            this.entity = entity;
        }

        public void startNode(Expression node, Expression parentNode) {
            if (node instanceof ASTDbPath) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Expression contains a DB_PATH expression that is not allowed here: " + parentNode);
            }
        }

        public void finishedChild(Expression parentNode, int childIndex, boolean hasMoreChildren) {
            ASTPath replacement;
            Object childNode = parentNode.getOperand(childIndex);
            if (childNode instanceof ASTObjPath && (replacement = ExpressionPostProcessor.this.pathCache.getPathDescriptor(this.entity, (ASTObjPath)childNode).getPathExp()) != childNode) {
                parentNode.setOperand(childIndex, (Object)replacement);
            }
        }

        public void objectNode(Object leaf, Expression parentNode) {
            block4: {
                block5: {
                    block3: {
                        if (!(leaf instanceof JsonNode)) break block3;
                        for (int i = 0; i < parentNode.getOperandCount(); ++i) {
                            if (leaf != parentNode.getOperand(i)) continue;
                            parentNode.setOperand(i, this.convert((SimpleNode)parentNode, (JsonNode)leaf));
                        }
                        break block4;
                    }
                    if (!(leaf instanceof Object[])) break block5;
                    Object[] array = (Object[])leaf;
                    for (int i = 0; i < array.length; ++i) {
                        if (!(array[i] instanceof JsonNode)) continue;
                        array[i] = this.convert((SimpleNode)parentNode, (JsonNode)array[i]);
                    }
                    break block4;
                }
                if (!(leaf instanceof String)) break block4;
                for (int i = 0; i < parentNode.getOperandCount(); ++i) {
                    if (leaf != parentNode.getOperand(i)) continue;
                    parentNode.setOperand(i, this.convert((SimpleNode)parentNode, (JsonNode)TextNode.valueOf((String)((String)leaf))));
                }
            }
        }

        private Object convert(SimpleNode parentExp, JsonNode node) {
            JsonValueConverter converter;
            PathDescriptor pd;
            ASTObjPath peerPath = this.findPeerPath(parentExp, node);
            if (peerPath != null && (pd = ExpressionPostProcessor.this.pathCache.getPathDescriptor(this.entity, peerPath)).isAttribute() && (converter = (JsonValueConverter)ExpressionPostProcessor.this.converters.get(pd.getType())) != null) {
                try {
                    return converter.value(node);
                }
                catch (Exception e) {
                    throw new LinkRestException(Response.Status.BAD_REQUEST, "Expression parameters contain an incorrectly formatted value: '" + node.asText() + "'", e);
                }
            }
            return node.asText();
        }

        private ASTObjPath findPeerPath(SimpleNode exp, Object child) {
            if (exp == null) {
                return null;
            }
            if (!(exp instanceof ConditionNode)) {
                return this.findPeerPath((SimpleNode)exp.jjtGetParent(), exp);
            }
            int len = exp.getOperandCount();
            for (int i = 0; i < len; ++i) {
                ASTObjPath path;
                Object operand = exp.getOperand(i);
                if (operand == child || !(operand instanceof Expression) || (path = this.findChildPath((Expression)operand)) == null) continue;
                return path;
            }
            return null;
        }

        private ASTObjPath findChildPath(Expression exp) {
            if (exp instanceof ASTObjPath) {
                return (ASTObjPath)exp;
            }
            int len = exp.getOperandCount();
            for (int i = 0; i < len; ++i) {
                ASTObjPath path;
                Object operand = exp.getOperand(i);
                if (!(operand instanceof Expression) || (path = this.findChildPath((Expression)operand)) == null) continue;
                return path;
            }
            return null;
        }
    }
}

