/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.filter;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.runtime.jackson.IJacksonService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;

class CayenneExpProcessorWorker {
    private static final String EXP = "exp";
    private static final String PARAMS = "params";
    private IJacksonService jsonParser;

    CayenneExpProcessorWorker(IJacksonService jsonParser) {
        this.jsonParser = jsonParser;
    }

    Expression exp(String cayenneExp) {
        if (cayenneExp == null) {
            return null;
        }
        Expression exp = cayenneExp.startsWith("[") ? this.processArray(this.jsonParser.parseJson(cayenneExp)) : (cayenneExp.startsWith("{") ? this.processMap(this.jsonParser.parseJson(cayenneExp)) : this.processExp(cayenneExp));
        return exp;
    }

    Expression exp(JsonNode cayenneExp) {
        if (cayenneExp == null) {
            return null;
        }
        Expression exp = cayenneExp.isArray() ? this.processArray(cayenneExp) : (cayenneExp.isObject() ? this.processMap(cayenneExp) : this.processExp(cayenneExp.asText()));
        return exp;
    }

    private Expression processExp(String cayenneExp) {
        return ExpressionFactory.exp((String)cayenneExp, (Object[])new Object[0]);
    }

    private Expression processMap(JsonNode map) {
        JsonNode expNode = map.get(EXP);
        if (expNode == null) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "'exp' key is missing in 'cayenneExp' map");
        }
        Expression exp = ExpressionFactory.exp((String)expNode.asText(), (Object[])new Object[0]);
        JsonNode paramsNode = map.get(PARAMS);
        if (paramsNode != null) {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            Iterator it = paramsNode.fieldNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                JsonNode valueNode = paramsNode.get(key);
                Object value = CayenneExpProcessorWorker.extractValue(valueNode);
                paramsMap.put(key, value);
            }
            exp = exp.params(paramsMap);
        }
        return exp;
    }

    private Expression processArray(JsonNode array) {
        int len = array.size();
        if (len < 1) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "array 'cayenneExp' mist have at least one element");
        }
        String expString = array.get(0).asText();
        if (len < 2) {
            return ExpressionFactory.exp((String)expString, (Object[])new Object[0]);
        }
        Object[] params = new Object[len - 1];
        for (int i = 1; i < len; ++i) {
            JsonNode paramNode = array.get(i);
            params[i - 1] = CayenneExpProcessorWorker.extractValue(paramNode);
        }
        return ExpressionFactory.exp((String)expString, (Object[])params);
    }

    private static Object extractValue(JsonNode valueNode) {
        JsonToken type = valueNode.asToken();
        switch (type) {
            case VALUE_NUMBER_INT: {
                return valueNode.asInt();
            }
            case VALUE_NUMBER_FLOAT: {
                return valueNode.asDouble();
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_NULL: {
                return null;
            }
            case START_ARRAY: {
                return CayenneExpProcessorWorker.extractArray(valueNode);
            }
        }
        return valueNode;
    }

    private static List<Object> extractArray(JsonNode arrayNode) {
        ArrayList<Object> values = new ArrayList<Object>(arrayNode.size());
        for (JsonNode value : arrayNode) {
            values.add(CayenneExpProcessorWorker.extractValue(value));
        }
        return values;
    }
}

