/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.converter;

import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.parser.converter.Base64Converter;
import com.nhl.link.rest.parser.converter.FloatConverter;
import com.nhl.link.rest.parser.converter.GenericConverter;
import com.nhl.link.rest.parser.converter.ISOLocalDateConverter;
import com.nhl.link.rest.parser.converter.ISOLocalDateTimeConverter;
import com.nhl.link.rest.parser.converter.ISOLocalTimeConverter;
import com.nhl.link.rest.parser.converter.JsonValueConverter;
import com.nhl.link.rest.parser.converter.LongConverter;
import com.nhl.link.rest.parser.converter.UtcDateConverter;
import com.nhl.link.rest.runtime.parser.converter.IJsonValueConverterFactory;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

public class DefaultJsonValueConverterFactory
implements IJsonValueConverterFactory {
    protected Map<Class<?>, JsonValueConverter> convertersByJavaType;
    private JsonValueConverter defaultConverter = GenericConverter.converter();

    public DefaultJsonValueConverterFactory() {
        this.convertersByJavaType = new HashMap();
        this.convertersByJavaType.put(Object.class, GenericConverter.converter());
        this.convertersByJavaType.put(Float.class, FloatConverter.converter());
        this.convertersByJavaType.put(Float.TYPE, FloatConverter.converter());
        this.convertersByJavaType.put(Long.class, LongConverter.converter());
        this.convertersByJavaType.put(Long.TYPE, LongConverter.converter());
        this.convertersByJavaType.put(java.util.Date.class, UtcDateConverter.converter());
        this.convertersByJavaType.put(Date.class, UtcDateConverter.converter());
        this.convertersByJavaType.put(Time.class, UtcDateConverter.converter());
        this.convertersByJavaType.put(Timestamp.class, UtcDateConverter.converter());
        this.convertersByJavaType.put(byte[].class, Base64Converter.converter());
        this.convertersByJavaType.put(LocalDate.class, ISOLocalDateConverter.converter());
        this.convertersByJavaType.put(LocalTime.class, ISOLocalTimeConverter.converter());
        this.convertersByJavaType.put(LocalDateTime.class, ISOLocalDateTimeConverter.converter());
    }

    @Override
    public JsonValueConverter converter(Class<?> valueType) {
        JsonValueConverter converter = this.convertersByJavaType.get(valueType);
        return converter != null ? converter : this.defaultConverter;
    }

    @Override
    public JsonValueConverter converter(LrAttribute attribute) {
        return this.converter(attribute.getType());
    }

    @Override
    public JsonValueConverter converter(LrEntity<?> entity) {
        int ids = entity.getIds().size();
        if (ids != 1) {
            throw new IllegalArgumentException("Entity '" + entity.getName() + "' has unexpected number of ID attributes: " + ids);
        }
        return this.converter(entity.getIds().iterator().next().getType());
    }
}

