/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.cache;

import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.runtime.parser.cache.EntityPathCache;
import com.nhl.link.rest.runtime.parser.cache.IPathCache;
import com.nhl.link.rest.runtime.parser.cache.PathDescriptor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.exp.parser.ASTObjPath;

public class PathCache
implements IPathCache {
    private ConcurrentMap<String, EntityPathCache> pathCacheByEntity = new ConcurrentHashMap<String, EntityPathCache>();

    @Override
    public PathDescriptor getPathDescriptor(LrEntity<?> entity, ASTObjPath path) {
        return this.entityPathCache(entity).getPathDescriptor(path);
    }

    EntityPathCache entityPathCache(LrEntity<?> entity) {
        EntityPathCache pathCache = (EntityPathCache)this.pathCacheByEntity.get(entity.getName());
        if (pathCache != null) {
            return pathCache;
        }
        pathCache = new EntityPathCache(entity);
        EntityPathCache previousCache = this.pathCacheByEntity.putIfAbsent(entity.getName(), pathCache);
        if (previousCache != null) {
            pathCache = previousCache;
        }
        return pathCache;
    }
}

