/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser.cache;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.runtime.parser.cache.PathDescriptor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTPath;

class EntityPathCache {
    private LrEntity<?> entity;
    private Map<String, PathDescriptor> pathCache;

    EntityPathCache(final LrEntity<?> entity) {
        this.entity = entity;
        this.pathCache = new ConcurrentHashMap<String, PathDescriptor>();
        if (entity.getIds().size() == 1) {
            this.pathCache.put("id", new PathDescriptor(){
                LrAttribute id;
                {
                    this.id = entity.getIds().iterator().next();
                }

                @Override
                public boolean isAttribute() {
                    return true;
                }

                @Override
                public Class<?> getType() {
                    return this.id.getType();
                }

                @Override
                public ASTPath getPathExp() {
                    return this.id.getPathExp();
                }
            });
        }
    }

    PathDescriptor getPathDescriptor(final ASTObjPath path) {
        PathDescriptor entry = this.pathCache.get(path.getPath());
        if (entry == null) {
            String stringPath = (String)path.getOperand(0);
            final Object last = this.lastPathComponent(this.entity, stringPath);
            entry = last instanceof LrAttribute ? new PathDescriptor(){
                LrAttribute attribute;
                {
                    this.attribute = (LrAttribute)last;
                }

                @Override
                public boolean isAttribute() {
                    return true;
                }

                @Override
                public Class<?> getType() {
                    return this.attribute.getType();
                }

                @Override
                public ASTPath getPathExp() {
                    return path;
                }
            } : new PathDescriptor(){
                LrRelationship relationship;
                Class<?> type;
                {
                    this.relationship = (LrRelationship)last;
                    this.type = this.relationship.getTargetEntity().getType();
                }

                @Override
                public boolean isAttribute() {
                    return false;
                }

                @Override
                public Class<?> getType() {
                    return this.type;
                }

                @Override
                public ASTPath getPathExp() {
                    return path;
                }
            };
            this.pathCache.put(path.getPath(), entry);
        }
        return entry;
    }

    Object lastPathComponent(LrEntity<?> entity, String path) {
        int dot = path.indexOf(46);
        if (dot == 0 || dot == path.length() - 1) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid path '" + path + "' for '" + entity.getName() + "'");
        }
        if (dot > 0) {
            String segment = this.toRelationshipName(path.substring(0, dot));
            LrRelationship relationship = entity.getRelationship(segment);
            if (relationship == null) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid path '" + path + "' for '" + entity.getName() + "'. Not a relationship");
            }
            LrEntity<?> targetEntity = relationship.getTargetEntity();
            return this.lastPathComponent(targetEntity, path.substring(dot + 1));
        }
        LrAttribute attribute = entity.getAttribute(path);
        if (attribute != null) {
            return attribute;
        }
        LrRelationship relationship = entity.getRelationship(this.toRelationshipName(path));
        if (relationship != null) {
            return relationship;
        }
        throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid path '" + path + "' for '" + entity.getName() + "'");
    }

    private String toRelationshipName(String pathSegment) {
        return pathSegment.endsWith("+") ? pathSegment.substring(0, pathSegment.length() - 1) : pathSegment;
    }
}

