/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.nhl.link.rest.EntityUpdate;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.runtime.jackson.IJacksonService;
import com.nhl.link.rest.runtime.parser.EntityJsonTraverser;
import com.nhl.link.rest.runtime.parser.EntityJsonVisitor;
import com.nhl.link.rest.runtime.parser.IUpdateParser;
import com.nhl.link.rest.runtime.parser.converter.IJsonValueConverterFactory;
import com.nhl.link.rest.runtime.semantics.IRelationshipMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.cayenne.di.Inject;

public class UpdateParser
implements IUpdateParser {
    protected IJacksonService jacksonService;
    private EntityJsonTraverser entityJsonTraverser;

    public UpdateParser(@Inject IRelationshipMapper relationshipMapper, @Inject IJacksonService jacksonService, @Inject IJsonValueConverterFactory converterFactory) {
        this.jacksonService = jacksonService;
        this.entityJsonTraverser = new EntityJsonTraverser(relationshipMapper, converterFactory);
    }

    @Override
    public <T> Collection<EntityUpdate<T>> parse(LrEntity<T> entity, InputStream entityStream) {
        JsonNode node = this.jacksonService.parseJson(entityStream);
        return this.parse(entity, node);
    }

    @Override
    public <T> Collection<EntityUpdate<T>> parse(LrEntity<T> entity, String entityData) {
        JsonNode node = this.jacksonService.parseJson(entityData);
        return this.parse(entity, node);
    }

    protected <T> Collection<EntityUpdate<T>> parse(LrEntity<T> entity, JsonNode json) {
        UpdateVisitor<T> visitor = this.updateVisitor(entity);
        this.entityJsonTraverser().traverse(entity, json, visitor);
        return visitor.getUpdates();
    }

    protected EntityJsonTraverser entityJsonTraverser() {
        return this.entityJsonTraverser;
    }

    protected <T> UpdateVisitor<T> updateVisitor(LrEntity<T> entity) {
        return new UpdateVisitor<T>(entity);
    }

    protected static class UpdateVisitor<T>
    implements EntityJsonVisitor {
        private LrEntity<T> entity;
        private Collection<EntityUpdate<T>> updates;
        private EntityUpdate<T> currentUpdate;

        protected UpdateVisitor(LrEntity<T> entity) {
            this.entity = entity;
            this.updates = new ArrayList<EntityUpdate<T>>();
        }

        @Override
        public void beginObject() {
            this.currentUpdate = new EntityUpdate<T>(this.entity);
        }

        @Override
        public void visitId(String name, Object value) {
            this.currentUpdate.getOrCreateId().put(name, value);
        }

        @Override
        public void visitId(Map<String, Object> value) {
            this.currentUpdate.getOrCreateId().putAll(value);
        }

        @Override
        public void visitAttribute(String name, Object value) {
            this.currentUpdate.getValues().put(name, value);
        }

        @Override
        public void visitRelationship(String name, Object relatedId) {
            this.currentUpdate.addRelatedId(name, relatedId);
        }

        @Override
        public void endObject() {
            this.updates.add(this.currentUpdate);
            this.currentUpdate = null;
        }

        Collection<EntityUpdate<T>> getUpdates() {
            return this.updates;
        }
    }
}

