/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser;

import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.runtime.parser.BaseRequestProcessor;
import com.nhl.link.rest.runtime.parser.IRequestParser;
import com.nhl.link.rest.runtime.parser.filter.ICayenneExpProcessor;
import com.nhl.link.rest.runtime.parser.filter.IKeyValueExpProcessor;
import com.nhl.link.rest.runtime.parser.sort.ISortProcessor;
import com.nhl.link.rest.runtime.parser.tree.ITreeProcessor;
import com.nhl.link.rest.runtime.parser.tree.IncludeWorker;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParser
implements IRequestParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestParser.class);
    private static final String START = "start";
    private static final String LIMIT = "limit";
    private static final String CAYENNE_EXP = "cayenneExp";
    private static final String MAP_BY = "mapBy";
    private static final String QUERY = "query";
    private ITreeProcessor treeProcessor;
    private ISortProcessor sortProcessor;
    private ICayenneExpProcessor cayenneExpProcessor;
    private IKeyValueExpProcessor keyValueExpProcessor;

    protected static Expression combine(Expression e1, Expression e2) {
        return e1 == null ? e2 : (e2 == null ? e1 : e1.andExp(e2));
    }

    public RequestParser(@Inject ITreeProcessor treeProcessor, @Inject ISortProcessor sortProcessor, @Inject ICayenneExpProcessor cayenneExpProcessor, @Inject IKeyValueExpProcessor keyValueExpProcessor) {
        this.sortProcessor = sortProcessor;
        this.treeProcessor = treeProcessor;
        this.cayenneExpProcessor = cayenneExpProcessor;
        this.keyValueExpProcessor = keyValueExpProcessor;
    }

    @Override
    public <T> ResourceEntity<T> parseSelect(LrEntity<T> entity, Map<String, List<String>> protocolParameters, String autocompleteProperty) {
        ResourceEntity<T> resourceEntity = new ResourceEntity<T>(entity);
        resourceEntity.setFetchOffset(BaseRequestProcessor.integer(protocolParameters, START));
        resourceEntity.setFetchLimit(BaseRequestProcessor.integer(protocolParameters, LIMIT));
        this.treeProcessor.process(resourceEntity, protocolParameters);
        this.sortProcessor.process(resourceEntity, protocolParameters);
        this.processMapBy(resourceEntity, protocolParameters);
        Expression e1 = this.parseCayenneExp(entity, protocolParameters);
        Expression e2 = this.parseKeyValueExp(entity, protocolParameters, autocompleteProperty);
        resourceEntity.andQualifier(RequestParser.combine(e1, e2));
        return resourceEntity;
    }

    @Override
    public <T> ResourceEntity<T> parseUpdate(LrEntity<T> entity, Map<String, List<String>> protocolParameters) {
        ResourceEntity<T> resourceEntity = new ResourceEntity<T>(entity);
        this.treeProcessor.process(resourceEntity, protocolParameters);
        return resourceEntity;
    }

    private void processMapBy(ResourceEntity<?> descriptor, Map<String, List<String>> protocolParameters) {
        String mapByPath = BaseRequestProcessor.string(protocolParameters, MAP_BY);
        if (mapByPath != null) {
            LrAttribute attribute = descriptor.getLrEntity().getAttribute(mapByPath);
            if (attribute != null) {
                ResourceEntity mapBy = new ResourceEntity(descriptor.getLrEntity());
                mapBy.getAttributes().put(attribute.getName(), attribute);
                descriptor.mapBy(mapBy, attribute.getName());
            } else {
                ResourceEntity mapBy = new ResourceEntity(descriptor.getLrEntity());
                IncludeWorker.processIncludePath(mapBy, mapByPath);
                descriptor.mapBy(mapBy, mapByPath);
            }
        }
    }

    protected Expression parseCayenneExp(LrEntity<?> entity, Map<String, List<String>> protocolParameters) {
        String exp = BaseRequestProcessor.string(protocolParameters, CAYENNE_EXP);
        return this.cayenneExpProcessor.process(entity, exp);
    }

    protected Expression parseKeyValueExp(LrEntity<?> entity, Map<String, List<String>> protocolParameters, String autocompleteProperty) {
        String value = BaseRequestProcessor.string(protocolParameters, QUERY);
        return this.keyValueExpProcessor.process(entity, autocompleteProperty, value);
    }
}

