/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrPersistentAttribute;
import com.nhl.link.rest.meta.LrPersistentRelationship;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.parser.converter.JsonValueConverter;
import com.nhl.link.rest.runtime.parser.EntityJsonVisitor;
import com.nhl.link.rest.runtime.parser.converter.IJsonValueConverterFactory;
import com.nhl.link.rest.runtime.semantics.IRelationshipMapper;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityJsonTraverser {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityJsonTraverser.class);
    private IRelationshipMapper relationshipMapper;
    private IJsonValueConverterFactory converterFactory;

    public EntityJsonTraverser(IRelationshipMapper relationshipMapper, IJsonValueConverterFactory converterFactory) {
        this.relationshipMapper = relationshipMapper;
        this.converterFactory = converterFactory;
    }

    public void traverse(LrEntity<?> entity, JsonNode json, EntityJsonVisitor visitor) {
        if (json != null) {
            if (json.isArray()) {
                this.processArray(entity, json, visitor);
            } else if (json.isObject()) {
                this.processObject(entity, json, visitor);
            } else {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Expected Object or Array. Got: " + json.asText());
            }
        }
    }

    private void processArray(LrEntity<?> entity, JsonNode arrayNode, EntityJsonVisitor visitor) {
        for (JsonNode node : arrayNode) {
            if (node.isObject()) {
                this.processObject(entity, node, visitor);
                continue;
            }
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Expected Object, got: " + node.asText());
        }
    }

    private void processObject(LrEntity<?> entity, JsonNode objectNode, EntityJsonVisitor visitor) {
        visitor.beginObject();
        Iterator it = objectNode.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            if ("id".equals(key)) {
                JsonNode valueNode = objectNode.get(key);
                this.extractPK(entity, visitor, valueNode);
                continue;
            }
            LrAttribute attribute = entity.getAttribute(key);
            if (attribute != null) {
                JsonNode valueNode = objectNode.get(key);
                Object value = this.converter(attribute).value(valueNode);
                visitor.visitAttribute(key, value);
                continue;
            }
            LrRelationship relationship = this.relationshipMapper.toRelationship(entity, key);
            if (relationship instanceof LrPersistentRelationship) {
                JsonNode valueNode = objectNode.get(key);
                this.processRelationship(visitor, (LrPersistentRelationship)relationship, valueNode);
                continue;
            }
            LOGGER.info("Skipping unknown attribute '" + key + "'");
        }
        visitor.endObject();
    }

    private void processRelationship(EntityJsonVisitor visitor, LrPersistentRelationship relationship, JsonNode valueNode) {
        ArrayNode arrayNode;
        if (relationship.isPrimaryKey()) {
            if (valueNode.isArray()) {
                arrayNode = (ArrayNode)valueNode;
                if (arrayNode.size() > 1) {
                    throw new LinkRestException(Response.Status.BAD_REQUEST, "Relationship is a part of the primary key, only one related object allowed: " + relationship.getName());
                }
                if (arrayNode.size() == 1) {
                    valueNode = arrayNode.get(0);
                }
            }
            relationship.extractId(valueNode).forEach(visitor::visitId);
        }
        if (valueNode.isArray()) {
            arrayNode = (ArrayNode)valueNode;
            if (arrayNode.size() == 0) {
                this.addRelatedObject(visitor, relationship, null);
            } else {
                for (int i = 0; i < arrayNode.size(); ++i) {
                    this.addRelatedObject(visitor, relationship, this.converter(relationship).value(arrayNode.get(i)));
                }
            }
        } else if (relationship.isToMany() && valueNode.isNull()) {
            LOGGER.warn("Unexpected 'null' for a to-many relationship: " + relationship.getName() + ". Skipping...");
        } else {
            this.addRelatedObject(visitor, relationship, this.converter(relationship).value(valueNode));
        }
    }

    private void addRelatedObject(EntityJsonVisitor visitor, LrRelationship relationship, Object value) {
        visitor.visitRelationship(relationship.getName(), value);
    }

    protected void extractPK(LrEntity<?> entity, EntityJsonVisitor visitor, JsonNode valueNode) {
        Collection<LrAttribute> ids = entity.getIds();
        if (ids.size() == 1) {
            this.extractPKPart(visitor::visitId, ids.iterator().next(), valueNode);
            return;
        }
        for (LrAttribute id : ids) {
            JsonNode idNode = valueNode.get(id.getName());
            if (idNode == null) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Failed to parse update payload -- ID part is missing: " + id.getName());
            }
            this.extractPKPart(visitor::visitId, id, idNode);
        }
    }

    protected void extractPKPart(BiConsumer<String, Object> idConsumer, LrAttribute id, JsonNode valueNode) {
        String name = id instanceof LrPersistentAttribute ? ((LrPersistentAttribute)id).getColumnName() : id.getName();
        Object value = this.converter(id).value(valueNode);
        idConsumer.accept(name, value);
    }

    private JsonValueConverter converter(LrAttribute attribute) {
        return this.converterFactory.converter(attribute.getType());
    }

    private JsonValueConverter converter(LrRelationship relationship) {
        return this.converterFactory.converter(relationship.getTargetEntity());
    }
}

