/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.meta;

import com.nhl.link.rest.meta.LrResource;
import com.nhl.link.rest.meta.parser.IResourceParser;
import com.nhl.link.rest.runtime.meta.IResourceMetadataService;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.di.Inject;

public class ResourceMetadataService
implements IResourceMetadataService {
    private IResourceParser resourceParser;
    private ConcurrentMap<Class<?>, Collection<LrResource<?>>> classResources;

    public ResourceMetadataService(@Inject IResourceParser resourceParser) {
        this.resourceParser = resourceParser;
        this.classResources = new ConcurrentHashMap();
    }

    @Override
    public Collection<LrResource<?>> getLrResources(Class<?> resourceClass) {
        Collection<LrResource<?>> resources = (Collection<LrResource<?>>)this.classResources.get(resourceClass);
        if (resources == null) {
            Collection<LrResource<?>> newResources = this.resourceParser.parse(resourceClass);
            Collection<LrResource<?>> existingResources = this.classResources.putIfAbsent(resourceClass, newResources);
            resources = existingResources == null ? newResources : existingResources;
        }
        return resources;
    }
}

