/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.meta;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LazyLrDataMap;
import com.nhl.link.rest.meta.LrDataMap;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.compiler.LrEntityCompiler;
import com.nhl.link.rest.runtime.cayenne.ICayennePersister;
import com.nhl.link.rest.runtime.meta.IMetadataService;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Select;

public class MetadataService
implements IMetadataService {
    private EntityResolver entityResolver;
    private LrDataMap dataMap;

    public MetadataService(@Inject List<LrEntityCompiler> entityCompilers, @Inject ICayennePersister cayenneService) {
        this.entityResolver = cayenneService.entityResolver();
        this.dataMap = new LazyLrDataMap(entityCompilers);
    }

    @Override
    public <T> LrEntity<T> getLrEntity(Class<T> type) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        LrEntity<T> e = this.dataMap.getEntity(type);
        if (e == null) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid entity: " + type.getName());
        }
        return e;
    }

    @Override
    @Deprecated
    public <T> LrEntity<T> getLrEntity(Select<T> query) {
        Class type = query.getMetaData(this.entityResolver).getClassDescriptor().getObjectClass();
        return this.getLrEntity(type);
    }

    @Override
    public <T> LrEntity<T> getEntityByType(Type entityType) {
        LrEntity<?> entity = this.getLrEntity(this.entityTypeForParamType(entityType));
        if (entity == null) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "EntityUpdate type '" + entityType.getTypeName() + "' is not an entity");
        }
        return entity;
    }

    Class<?> entityTypeForParamType(Type paramType) {
        Type[] typeArgs;
        if (paramType instanceof ParameterizedType && (typeArgs = ((ParameterizedType)paramType).getActualTypeArguments()).length == 1) {
            Type[] upperBounds;
            if (typeArgs[0] instanceof Class) {
                return (Class)typeArgs[0];
            }
            if (typeArgs[0] instanceof WildcardType && (upperBounds = ((WildcardType)typeArgs[0]).getUpperBounds()).length == 1 && upperBounds[0] instanceof Class) {
                return (Class)upperBounds[0];
            }
        }
        return Object.class;
    }
}

