/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.listener;

import com.nhl.link.rest.processor.ProcessingContext;
import com.nhl.link.rest.runtime.listener.EventGroup;
import com.nhl.link.rest.runtime.listener.IListenerService;
import com.nhl.link.rest.runtime.listener.ListenerInvocation;
import com.nhl.link.rest.runtime.listener.ListenerInvocationFactory;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;

public abstract class ListenersBuilder<E extends Enum<E>> {
    private ProcessingContext<?> context;
    private EventGroup eventGroup;
    private IListenerService listenerService;

    public ListenersBuilder(IListenerService listenerService, ProcessingContext<?> context, EventGroup eventGroup) {
        this.context = context;
        this.eventGroup = eventGroup;
        this.listenerService = listenerService;
    }

    protected abstract E mapStage(Class<? extends Annotation> var1);

    protected abstract void appendInvocation(E var1, ListenerInvocation var2);

    public ListenersBuilder addListener(Object listener) {
        Map<Class<? extends Annotation>, List<ListenerInvocationFactory>> factories = this.listenerService.getFactories(listener.getClass(), this.context, this.eventGroup);
        if (factories.isEmpty()) {
            return this;
        }
        for (Map.Entry<Class<? extends Annotation>, List<ListenerInvocationFactory>> e : factories.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            E stage = this.mapStage(e.getKey());
            e.getValue().forEach(factory -> this.appendInvocation(stage, factory.toInvocation(listener)));
        }
        return this;
    }
}

