/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.listener;

import com.nhl.link.rest.processor.ProcessingContext;
import com.nhl.link.rest.runtime.listener.EventGroup;
import com.nhl.link.rest.runtime.listener.IListenerService;
import com.nhl.link.rest.runtime.listener.ListenerInvocationFactory;
import com.nhl.link.rest.runtime.listener.ListenerInvocationFactoryCompiler;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ListenerService
implements IListenerService {
    private ListenerInvocationFactoryCompiler compiler = new ListenerInvocationFactoryCompiler();
    private ConcurrentMap<String, Map<Class<? extends Annotation>, List<ListenerInvocationFactory>>>[] factories = new ConcurrentMap[EventGroup.values().length];

    public ListenerService() {
        for (int i = 0; i < this.factories.length; ++i) {
            this.factories[i] = new ConcurrentHashMap<String, Map<Class<? extends Annotation>, List<ListenerInvocationFactory>>>();
        }
    }

    private String factoriesKey(Class<?> listenerType, ProcessingContext<?> context) {
        return listenerType.getName() + "|" + context.getType().getName();
    }

    @Override
    public Map<Class<? extends Annotation>, List<ListenerInvocationFactory>> getFactories(Class<?> listenerType, ProcessingContext<?> context, EventGroup eventGroup) {
        String key;
        if (listenerType == null) {
            throw new NullPointerException("Null type");
        }
        if (eventGroup == null) {
            throw new NullPointerException("Null eventGroup");
        }
        ConcurrentMap<String, Map<Class<? extends Annotation>, List<ListenerInvocationFactory>>> factoriesForEventGroup = this.factories[eventGroup.ordinal()];
        Map<Class<? extends Annotation>, List<ListenerInvocationFactory>> factoriesForListener = (Map<Class<? extends Annotation>, List<ListenerInvocationFactory>>)factoriesForEventGroup.get(key = this.factoriesKey(listenerType, context));
        if (factoriesForListener == null) {
            Map<Class<? extends Annotation>, List<ListenerInvocationFactory>> newFactories = this.compiler.compileFactories(listenerType, context, eventGroup);
            Map<Class<? extends Annotation>, List<ListenerInvocationFactory>> oldFactories = factoriesForEventGroup.putIfAbsent(key, newFactories);
            factoriesForListener = oldFactories != null ? oldFactories : newFactories;
        }
        return factoriesForListener;
    }
}

