/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.listener;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.processor.ProcessingContext;
import com.nhl.link.rest.processor.ProcessingStage;
import com.nhl.link.rest.runtime.listener.EventGroup;
import com.nhl.link.rest.runtime.listener.ListenerInvocation;
import com.nhl.link.rest.runtime.listener.ListenerInvocationFactory;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ListenerInvocationFactoryCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListenerInvocationFactoryCompiler.class);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    ListenerInvocationFactoryCompiler() {
    }

    Map<Class<? extends Annotation>, List<ListenerInvocationFactory>> compileFactories(Class<?> listenerType, ProcessingContext<?> context, EventGroup eventGroup) {
        Class<?> entityType = context.getType();
        ConcurrentHashMap<Class<? extends Annotation>, List<ListenerInvocationFactory>> map = new ConcurrentHashMap<Class<? extends Annotation>, List<ListenerInvocationFactory>>();
        block0: for (MethodDescriptor descriptor : this.collectMethods(listenerType, new HashSet<MethodDescriptor>())) {
            ListenerInvocationFactory invocationFactory = null;
            Method m = descriptor.getMethod();
            for (Class<? extends Annotation> at : eventGroup.getEventsFired()) {
                Annotation a = m.getAnnotation(at);
                if (a == null || !this.checkMethodIsPublic(a, m)) continue;
                if (invocationFactory == null && (invocationFactory = this.compileFactory(m, entityType)) == null) continue block0;
                ArrayList<ListenerInvocationFactory> list = (ArrayList<ListenerInvocationFactory>)map.get(at);
                if (list == null) {
                    list = new ArrayList<ListenerInvocationFactory>();
                    map.put(at, list);
                }
                list.add(invocationFactory);
            }
        }
        return map;
    }

    private Set<MethodDescriptor> collectMethods(Class<?> listenerType, Set<MethodDescriptor> acc) {
        if (listenerType.getSuperclass() != null) {
            this.collectMethods(listenerType.getSuperclass(), acc);
        }
        for (Method m : listenerType.getDeclaredMethods()) {
            MethodDescriptor descriptor = new MethodDescriptor(m);
            if (acc.contains(descriptor)) {
                acc.remove(descriptor);
            }
            acc.add(descriptor);
        }
        return acc;
    }

    private boolean checkMethodIsPublic(Annotation at, Method m) {
        boolean isPublic = Modifier.isPublic(m.getModifiers());
        if (!isPublic) {
            LOGGER.warn(String.format("Listener method %s.%s(...) for the @%s event is not public, skipping...", m.getDeclaringClass().getName(), m.getName(), at.annotationType().getSimpleName()));
        }
        return isPublic;
    }

    private ListenerInvocationFactory compileFactory(final Method m, Class<?> entityType) {
        final boolean voidMethod = m.getReturnType().equals(Void.TYPE);
        final Invoker invoker = this.checkParamTypesAndCompileInvoker(m);
        if (!invoker.getEntityType().isAssignableFrom(entityType)) {
            return null;
        }
        return new ListenerInvocationFactory(){
            MethodHandle handle;
            {
                this.handle = ListenerInvocationFactoryCompiler.this.toHandle(m);
            }

            @Override
            public ListenerInvocation toInvocation(Object listener) {
                MethodHandle invokable = this.handle.bindTo(listener);
                return new ListenerInvocation(invokable, voidMethod){

                    @Override
                    protected <C extends ProcessingContext<T>, T> ProcessingStage<C, ? super T> doInvokeOld(C context, ProcessingStage<C, ? super T> next) throws Throwable {
                        return (ProcessingStage)invoker.invoke(this.methodHandle, context, next);
                    }
                };
            }
        };
    }

    Invoker checkParamTypesAndCompileInvoker(Method m) {
        Class<?>[] paramTypes = m.getParameterTypes();
        Type[] genericParamTypes = m.getGenericParameterTypes();
        switch (paramTypes.length) {
            case 0: {
                return new Invoker(){

                    public Class<Object> getEntityType() {
                        return Object.class;
                    }

                    @Override
                    public <C extends ProcessingContext<T>, T> Object invoke(MethodHandle handle, C context, ProcessingStage<C, ? super T> next) throws Throwable {
                        return handle.invoke();
                    }
                };
            }
            case 1: {
                this.checkParamType(m.getName(), paramTypes[0], ProcessingContext.class);
                final Class<?> entityType1 = this.entityTypeForParamType(genericParamTypes[0]);
                return new Invoker(){

                    @Override
                    public Class<?> getEntityType() {
                        return entityType1;
                    }

                    @Override
                    public <C extends ProcessingContext<T>, T> Object invoke(MethodHandle handle, C context, ProcessingStage<C, ? super T> next) throws Throwable {
                        return handle.invoke(context);
                    }
                };
            }
            case 2: {
                this.checkParamType(m.getName(), paramTypes[0], ProcessingContext.class);
                this.checkParamType(m.getName(), paramTypes[1], ProcessingStage.class);
                final Class<?> entityType2 = this.entityTypeForParamType(genericParamTypes[0]);
                return new Invoker(){

                    @Override
                    public Class<?> getEntityType() {
                        return entityType2;
                    }

                    @Override
                    public <C extends ProcessingContext<T>, T> Object invoke(MethodHandle handle, C context, ProcessingStage<C, ? super T> next) throws Throwable {
                        return handle.invoke(context, next);
                    }
                };
            }
        }
        throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Annotated method is expected to have at most 2 arguments. Method '" + m.getName() + "' has " + paramTypes.length);
    }

    Class<?> entityTypeForParamType(Type paramType) {
        Type[] typeArgs;
        if (paramType instanceof ParameterizedType && (typeArgs = ((ParameterizedType)paramType).getActualTypeArguments()).length == 1) {
            Type[] upperBounds;
            if (typeArgs[0] instanceof Class) {
                return (Class)typeArgs[0];
            }
            if (typeArgs[0] instanceof WildcardType && (upperBounds = ((WildcardType)typeArgs[0]).getUpperBounds()).length == 1 && upperBounds[0] instanceof Class) {
                return (Class)upperBounds[0];
            }
        }
        return Object.class;
    }

    void checkParamType(String methodName, Class<?> type, Class<?> expectedType) {
        if (!expectedType.isAssignableFrom(type)) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Unexpected parameter type for listener method '" + methodName + "'. Should be " + expectedType.getName() + ", but was " + type.getName());
        }
    }

    MethodHandle toHandle(Method m) {
        try {
            return LOOKUP.unreflect(m);
        }
        catch (IllegalAccessException e) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Can't get a MethodHandle for a method: " + m.getName(), e);
        }
    }

    private static interface Invoker {
        public <C extends ProcessingContext<T>, T> Object invoke(MethodHandle var1, C var2, ProcessingStage<C, ? super T> var3) throws Throwable;

        public Class<?> getEntityType();
    }

    private class MethodDescriptor {
        private final Method m;
        private final String name;
        private final Class<?>[] parameterTypes;

        MethodDescriptor(Method m) {
            this.m = m;
            this.name = m.getName();
            Class<?>[] parameterTypes = m.getParameterTypes();
            this.parameterTypes = Arrays.copyOf(parameterTypes, parameterTypes.length);
        }

        Method getMethod() {
            return this.m;
        }

        String getName() {
            return this.name;
        }

        Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public int hashCode() {
            int hash = 0;
            for (Class<?> parameterType : this.parameterTypes) {
                hash += parameterType.hashCode();
                hash *= 31;
            }
            return hash += this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodDescriptor)) {
                return false;
            }
            MethodDescriptor that = (MethodDescriptor)obj;
            return this.name.equals(that.getName()) && Arrays.deepEquals(this.parameterTypes, that.getParameterTypes());
        }

        public String toString() {
            return this.m.getDeclaringClass().getName() + "." + this.m.getName() + "(...)";
        }
    }
}

