/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.listener;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.processor.ChainProcessor;
import com.nhl.link.rest.processor.ProcessingContext;
import com.nhl.link.rest.processor.ProcessingStage;
import com.nhl.link.rest.processor.ProcessorOutcome;
import java.lang.invoke.MethodHandle;
import javax.ws.rs.core.Response;

public abstract class ListenerInvocation {
    private static final ProcessingStage FAKE_START_STAGE = c -> null;
    protected MethodHandle methodHandle;
    protected boolean voidMethod;

    public ListenerInvocation(MethodHandle methodHandle, boolean voidMethod) {
        this.methodHandle = methodHandle;
        this.voidMethod = voidMethod;
    }

    public <C extends ProcessingContext<T>, T> ProcessorOutcome invoke(C context) {
        ProcessingStage<C, T> next = this.invokeOld(context, FAKE_START_STAGE);
        if (next == null) {
            return ProcessorOutcome.STOP;
        }
        if (next == FAKE_START_STAGE) {
            return ProcessorOutcome.CONTINUE;
        }
        ChainProcessor.execute(next, context);
        return ProcessorOutcome.STOP;
    }

    protected <C extends ProcessingContext<T>, T> ProcessingStage<C, ? super T> invokeOld(C context, ProcessingStage<C, ? super T> next) {
        ProcessingStage<C, ? super T> processor;
        try {
            processor = this.doInvokeOld(context, next);
        }
        catch (Throwable e) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Error invoking listener method", e);
        }
        return this.voidMethod ? next : processor;
    }

    protected abstract <C extends ProcessingContext<T>, T> ProcessingStage<C, ? super T> doInvokeOld(C var1, ProcessingStage<C, ? super T> var2) throws Throwable;
}

