/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.jackson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.runtime.jackson.IJacksonService;
import com.nhl.link.rest.runtime.jackson.JsonConvertable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.Response;

public class JacksonService
implements IJacksonService {
    private ObjectMapper sharedMapper = new ObjectMapper();
    private JsonFactory sharedFactory = this.sharedMapper.getFactory();

    public JacksonService() {
        SerializedString LINE_SEPARATOR = new SerializedString("\\u2028");
        SerializedString PARAGRAPH_SEPARATOR = new SerializedString("\\u2029");
        this.sharedFactory.setCharacterEscapes(new CharacterEscapes((SerializableString)LINE_SEPARATOR, (SerializableString)PARAGRAPH_SEPARATOR){
            private static final long serialVersionUID = 3995801066651016289L;
            final /* synthetic */ SerializableString val$LINE_SEPARATOR;
            final /* synthetic */ SerializableString val$PARAGRAPH_SEPARATOR;
            {
                this.val$LINE_SEPARATOR = serializableString;
                this.val$PARAGRAPH_SEPARATOR = serializableString2;
            }

            public int[] getEscapeCodesForAscii() {
                return 1.standardAsciiEscapesForJSON();
            }

            public SerializableString getEscapeSequence(int ch) {
                switch (ch) {
                    case 8232: {
                        return this.val$LINE_SEPARATOR;
                    }
                    case 8233: {
                        return this.val$PARAGRAPH_SEPARATOR;
                    }
                }
                return null;
            }
        });
        this.sharedFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        this.sharedMapper.disable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
    }

    @Override
    public JsonFactory getJsonFactory() {
        return this.sharedFactory;
    }

    @Override
    public void outputJson(JsonConvertable processor, OutputStream out) throws IOException {
        try (JsonGenerator generator = this.sharedFactory.createGenerator(out, JsonEncoding.UTF8);){
            processor.generateJSON(generator);
        }
    }

    @Override
    public JsonNode parseJson(String json) {
        if (json == null) {
            return null;
        }
        try {
            JsonParser parser = this.getJsonFactory().createParser(json);
            return (JsonNode)new ObjectMapper().readTree(parser);
        }
        catch (IOException ioex) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Error parsing JSON");
        }
    }

    @Override
    public JsonNode parseJson(InputStream json) {
        try {
            JsonParser parser = this.getJsonFactory().createParser(json);
            return (JsonNode)new ObjectMapper().readTree(parser);
        }
        catch (IOException ioex) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Error parsing JSON");
        }
    }
}

