/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.executor;

import com.nhl.link.rest.runtime.shutdown.ShutdownManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;

public class UnboundedExecutorServiceProvider
implements Provider<ExecutorService> {
    private ShutdownManager shutdownManager;

    public UnboundedExecutorServiceProvider(@Inject ShutdownManager shutdownManager) {
        this.shutdownManager = shutdownManager;
    }

    public ExecutorService get() throws DIRuntimeException {
        AtomicLong threadNumber = new AtomicLong();
        ExecutorService service = Executors.newCachedThreadPool(r -> new Thread(r, "link-rest-pool-" + threadNumber.getAndIncrement()));
        this.shutdownManager.addShutdownHook(service::shutdownNow);
        return service;
    }
}

