/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.encoder;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.encoder.converter.GenericConverter;
import com.nhl.link.rest.encoder.converter.ISODateConverter;
import com.nhl.link.rest.encoder.converter.ISODateTimeConverter;
import com.nhl.link.rest.encoder.converter.ISOTimeConverter;
import com.nhl.link.rest.encoder.converter.StringConverter;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrPersistentAttribute;
import com.nhl.link.rest.runtime.encoder.AttributeEncoderFactory;
import com.nhl.link.rest.runtime.encoder.IStringConverterFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;

public class StringConverterFactory
implements IStringConverterFactory {
    private Map<String, StringConverter> convertersByPath = new ConcurrentHashMap<String, StringConverter>();

    @Override
    public StringConverter getConverter(LrEntity<?> entity) {
        return this.getConverter(entity, null);
    }

    @Override
    public StringConverter getConverter(LrEntity<?> entity, String attributeName) {
        String key = attributeName != null ? entity.getName() + "." + attributeName : entity.getName();
        StringConverter converter = this.convertersByPath.get(key);
        if (converter == null) {
            converter = this.buildConverter(entity, attributeName);
            this.convertersByPath.put(key, converter);
        }
        return converter;
    }

    protected StringConverter buildConverter(LrEntity<?> entity, String attributeName) {
        if (attributeName == null) {
            return GenericConverter.converter();
        }
        LrAttribute attribute = entity.getAttribute(attributeName);
        if (attribute == null) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid attribute: '" + entity.getName() + "." + attributeName + "'");
        }
        if (AttributeEncoderFactory.UTIL_DATE.equals(attribute.getType())) {
            if (attribute instanceof LrPersistentAttribute) {
                LrPersistentAttribute persistentAttribute = (LrPersistentAttribute)attribute;
                int dbType = persistentAttribute.getJdbcType();
                if (dbType == 91) {
                    return ISODateConverter.converter();
                }
                if (dbType == 92) {
                    return ISOTimeConverter.converter();
                }
            }
            return ISODateTimeConverter.converter();
        }
        if (AttributeEncoderFactory.SQL_TIMESTAMP.equals(attribute.getType())) {
            return ISODateTimeConverter.converter();
        }
        if (AttributeEncoderFactory.SQL_DATE.equals(attribute.getType())) {
            return ISODateConverter.converter();
        }
        if (AttributeEncoderFactory.SQL_TIME.equals(attribute.getType())) {
            return ISOTimeConverter.converter();
        }
        return GenericConverter.converter();
    }
}

