/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.encoder;

import com.nhl.link.rest.EntityProperty;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.encoder.CollectionEncoder;
import com.nhl.link.rest.encoder.DataResponseEncoder;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.encoder.EncoderFilter;
import com.nhl.link.rest.encoder.EntityEncoder;
import com.nhl.link.rest.encoder.EntityMetadataEncoder;
import com.nhl.link.rest.encoder.EntityToOneEncoder;
import com.nhl.link.rest.encoder.FilterChainEncoder;
import com.nhl.link.rest.encoder.GenericEncoder;
import com.nhl.link.rest.encoder.ListEncoder;
import com.nhl.link.rest.encoder.MapByEncoder;
import com.nhl.link.rest.encoder.PropertyMetadataEncoder;
import com.nhl.link.rest.encoder.ResourceEncoder;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.property.PropertyBuilder;
import com.nhl.link.rest.runtime.encoder.IAttributeEncoderFactory;
import com.nhl.link.rest.runtime.encoder.IEncoderService;
import com.nhl.link.rest.runtime.encoder.IStringConverterFactory;
import com.nhl.link.rest.runtime.semantics.IRelationshipMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.di.Inject;

public class EncoderService
implements IEncoderService {
    protected IAttributeEncoderFactory attributeEncoderFactory;
    protected IRelationshipMapper relationshipMapper;
    private IStringConverterFactory stringConverterFactory;
    private List<EncoderFilter> filters;
    private Map<String, PropertyMetadataEncoder> propertyMetadataEncoders;
    private Map<ResourceEntity<?>, Encoder> entityMetadataEncoders;

    public EncoderService(@Inject List<EncoderFilter> filters, @Inject IAttributeEncoderFactory attributeEncoderFactory, @Inject IStringConverterFactory stringConverterFactory, @Inject IRelationshipMapper relationshipMapper, @Inject Map<String, PropertyMetadataEncoder> propertyMetadataEncoders) {
        this.attributeEncoderFactory = attributeEncoderFactory;
        this.relationshipMapper = relationshipMapper;
        this.stringConverterFactory = stringConverterFactory;
        this.filters = filters;
        this.propertyMetadataEncoders = propertyMetadataEncoders;
        this.entityMetadataEncoders = new ConcurrentHashMap();
    }

    @Override
    public <T> Encoder metadataEncoder(ResourceEntity<T> entity) {
        return new ResourceEncoder<T>(entity.getLrEntity(), entity.getApplicationBase(), this.entityMetadataEncoder(entity));
    }

    @Override
    public <T> Encoder dataEncoder(ResourceEntity<T> entity) {
        CollectionEncoder resultEncoder = this.resultEncoder(entity);
        return new DataResponseEncoder("data", resultEncoder, "total", GenericEncoder.encoder());
    }

    protected CollectionEncoder resultEncoder(ResourceEntity<?> entity) {
        Encoder elementEncoder = this.collectionElementEncoder(entity);
        boolean isMapBy = entity.getMapBy() != null;
        ListEncoder encoder = new ListEncoder(elementEncoder).withOffset(entity.getFetchOffset()).withLimit(entity.getFetchLimit()).shouldFilter(entity.isFiltered());
        return isMapBy ? new MapByEncoder(entity.getMapByPath(), null, entity.getMapBy(), encoder, this.stringConverterFactory, this.attributeEncoderFactory) : encoder;
    }

    protected Encoder nestedToManyEncoder(ResourceEntity<?> resourceEntity) {
        Encoder elementEncoder = this.collectionElementEncoder(resourceEntity);
        boolean isMapBy = resourceEntity.getMapBy() != null;
        ListEncoder listEncoder = new ListEncoder(elementEncoder, isMapBy ? null : resourceEntity.getQualifier(), resourceEntity.getOrderings());
        listEncoder.withOffset(resourceEntity.getFetchOffset()).withLimit(resourceEntity.getFetchLimit());
        if (resourceEntity.isFiltered()) {
            listEncoder.shouldFilter();
        }
        return isMapBy ? new MapByEncoder(resourceEntity.getMapByPath(), resourceEntity.getQualifier(), resourceEntity.getMapBy(), listEncoder, this.stringConverterFactory, this.attributeEncoderFactory) : listEncoder;
    }

    protected Encoder collectionElementEncoder(ResourceEntity<?> resourceEntity) {
        Encoder encoder = this.entityEncoder(resourceEntity);
        return this.filteredEncoder(encoder, resourceEntity);
    }

    protected Encoder toOneEncoder(ResourceEntity<?> resourceEntity, LrRelationship relationship) {
        Encoder valueEncoder = this.entityEncoder(resourceEntity);
        EntityToOneEncoder compositeValueEncoder = new EntityToOneEncoder(valueEncoder);
        return this.filteredEncoder(compositeValueEncoder, resourceEntity);
    }

    protected Encoder entityMetadataEncoder(ResourceEntity<?> resourceEntity) {
        Encoder encoder = this.entityMetadataEncoders.get(resourceEntity);
        if (encoder == null) {
            encoder = new EntityMetadataEncoder(resourceEntity.getLrEntity(), this.propertyMetadataEncoders);
            this.entityMetadataEncoders.put(resourceEntity, encoder);
        }
        return encoder;
    }

    protected Encoder entityEncoder(ResourceEntity<?> resourceEntity) {
        TreeMap<String, EntityProperty> attributeEncoders = new TreeMap<String, EntityProperty>();
        for (LrAttribute lrAttribute : resourceEntity.getAttributes().values()) {
            EntityProperty entityProperty = this.attributeEncoderFactory.getAttributeProperty(resourceEntity.getLrEntity(), lrAttribute);
            attributeEncoders.put(lrAttribute.getName(), entityProperty);
        }
        TreeMap<String, EntityProperty> relationshipEncoders = new TreeMap<String, EntityProperty>();
        for (Map.Entry<String, ResourceEntity<?>> entry : resourceEntity.getChildren().entrySet()) {
            LrRelationship relationship = resourceEntity.getLrEntity().getRelationship(entry.getKey());
            Encoder encoder = relationship.isToMany() ? this.nestedToManyEncoder(entry.getValue()) : this.toOneEncoder(entry.getValue(), relationship);
            EntityProperty property = this.attributeEncoderFactory.getRelationshipProperty(resourceEntity.getLrEntity(), relationship, encoder);
            relationshipEncoders.put(entry.getKey(), property);
        }
        TreeMap<String, EntityProperty> treeMap = new TreeMap<String, EntityProperty>();
        treeMap.putAll(resourceEntity.getExtraProperties());
        EntityProperty entityProperty = resourceEntity.isIdIncluded() ? this.attributeEncoderFactory.getIdProperty(resourceEntity) : PropertyBuilder.doNothingProperty();
        return new EntityEncoder(entityProperty, attributeEncoders, relationshipEncoders, treeMap);
    }

    protected Encoder filteredEncoder(Encoder encoder, ResourceEntity<?> resourceEntity) {
        ArrayList<EncoderFilter> matchingFilters = null;
        for (EncoderFilter filter : this.filters) {
            if (!filter.matches(resourceEntity)) continue;
            if (matchingFilters == null) {
                matchingFilters = new ArrayList<EncoderFilter>(3);
            }
            matchingFilters.add(filter);
        }
        return matchingFilters != null ? new FilterChainEncoder(encoder, matchingFilters) : encoder;
    }
}

