/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.encoder;

import com.nhl.link.rest.EntityProperty;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.encoder.GenericEncoder;
import com.nhl.link.rest.encoder.ISODateEncoder;
import com.nhl.link.rest.encoder.ISODateTimeEncoder;
import com.nhl.link.rest.encoder.ISOLocalDateEncoder;
import com.nhl.link.rest.encoder.ISOLocalDateTimeEncoder;
import com.nhl.link.rest.encoder.ISOLocalTimeEncoder;
import com.nhl.link.rest.encoder.ISOTimeEncoder;
import com.nhl.link.rest.encoder.IdEncoder;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrPersistentAttribute;
import com.nhl.link.rest.meta.LrPersistentEntity;
import com.nhl.link.rest.meta.LrPersistentRelationship;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.property.BeanPropertyReader;
import com.nhl.link.rest.property.IdPropertyReader;
import com.nhl.link.rest.property.PropertyBuilder;
import com.nhl.link.rest.runtime.encoder.IAttributeEncoderFactory;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.DataObject;

public class AttributeEncoderFactory
implements IAttributeEncoderFactory {
    static final Class<?> UTIL_DATE = java.util.Date.class;
    static final Class<?> SQL_DATE = Date.class;
    static final Class<?> SQL_TIME = Time.class;
    static final Class<?> SQL_TIMESTAMP = Timestamp.class;
    static final Class<?> LOCAL_DATE = LocalDate.class;
    static final Class<?> LOCAL_TIME = LocalTime.class;
    static final Class<?> LOCAL_DATETIME = LocalDateTime.class;
    private Map<String, EntityProperty> attributePropertiesByPath = new ConcurrentHashMap<String, EntityProperty>();
    private Map<String, EntityProperty> idPropertiesByEntity = new ConcurrentHashMap<String, EntityProperty>();
    private ConcurrentMap<LrEntity<?>, IdPropertyReader> idPropertyReaders = new ConcurrentHashMap();

    @Override
    public EntityProperty getAttributeProperty(LrEntity<?> entity, LrAttribute attribute) {
        String key = entity.getName() + "." + attribute.getName();
        EntityProperty property = this.attributePropertiesByPath.get(key);
        if (property == null) {
            property = this.buildAttributeProperty(entity, attribute);
            this.attributePropertiesByPath.put(key, property);
        }
        return property;
    }

    @Override
    public EntityProperty getRelationshipProperty(LrEntity<?> entity, LrRelationship relationship, Encoder encoder) {
        return this.buildRelationshipProperty(entity, relationship, encoder);
    }

    @Override
    public EntityProperty getIdProperty(ResourceEntity<?> entity) {
        String key = entity.getLrEntity().getName();
        EntityProperty property = this.idPropertiesByEntity.get(key);
        if (property == null) {
            property = this.buildIdProperty(entity);
            this.idPropertiesByEntity.put(key, property);
        }
        return property;
    }

    protected EntityProperty buildRelationshipProperty(LrEntity<?> entity, LrRelationship relationship, Encoder encoder) {
        boolean persistent = relationship instanceof LrPersistentRelationship;
        if (persistent && DataObject.class.isAssignableFrom(entity.getType())) {
            return PropertyBuilder.dataObjectProperty().encodedWith(encoder);
        }
        return PropertyBuilder.property().encodedWith(encoder);
    }

    protected EntityProperty buildAttributeProperty(LrEntity<?> entity, LrAttribute attribute) {
        boolean persistent = attribute instanceof LrPersistentAttribute;
        Encoder encoder = this.buildEncoder(attribute.getType(), this.getJdbcType(attribute));
        if (persistent && DataObject.class.isAssignableFrom(entity.getType())) {
            return PropertyBuilder.dataObjectProperty().encodedWith(encoder);
        }
        return PropertyBuilder.property().encodedWith(encoder);
    }

    protected EntityProperty buildIdProperty(ResourceEntity<?> entity) {
        Collection<LrAttribute> ids = entity.getLrEntity().getIds();
        if (entity.getLrEntity() instanceof LrPersistentEntity) {
            if (ids.size() > 1) {
                TreeMap<String, Encoder> valueEncoders = new TreeMap<String, Encoder>();
                for (LrAttribute id : ids) {
                    Encoder valueEncoder = this.buildEncoder(id.getType(), this.getJdbcType(id));
                    valueEncoders.put(id.getName(), valueEncoder);
                }
                return PropertyBuilder.property(this.getOrCreateIdPropertyReader(entity.getLrEntity())).encodedWith(new IdEncoder(valueEncoders));
            }
            LrAttribute id = ids.iterator().next();
            Encoder valueEncoder = this.buildEncoder(id.getType(), this.getJdbcType(id));
            return PropertyBuilder.property(this.getOrCreateIdPropertyReader(entity.getLrEntity())).encodedWith(new IdEncoder(valueEncoder));
        }
        if (ids.isEmpty()) {
            return PropertyBuilder.doNothingProperty();
        }
        LrAttribute id = ids.iterator().next();
        return PropertyBuilder.property(BeanPropertyReader.reader(id.getName()));
    }

    private int getJdbcType(LrAttribute attribute) {
        if (attribute instanceof LrPersistentAttribute) {
            return ((LrPersistentAttribute)attribute).getJdbcType();
        }
        return Integer.MIN_VALUE;
    }

    private IdPropertyReader getOrCreateIdPropertyReader(LrEntity<?> entity) {
        IdPropertyReader reader = (IdPropertyReader)this.idPropertyReaders.get(entity);
        if (reader == null) {
            reader = new IdPropertyReader(entity);
            IdPropertyReader oldReader = this.idPropertyReaders.putIfAbsent(entity, reader);
            reader = oldReader == null ? reader : oldReader;
        }
        return reader;
    }

    protected Encoder buildEncoder(Class<?> javaType, int jdbcType) {
        if (LOCAL_DATE.equals(javaType)) {
            return ISOLocalDateEncoder.encoder();
        }
        if (LOCAL_TIME.equals(javaType)) {
            return ISOLocalTimeEncoder.encoder();
        }
        if (LOCAL_DATETIME.equals(javaType)) {
            return ISOLocalDateTimeEncoder.encoder();
        }
        if (UTIL_DATE.equals(javaType)) {
            if (jdbcType == 91) {
                return ISODateEncoder.encoder();
            }
            if (jdbcType == 92) {
                return ISOTimeEncoder.encoder();
            }
            return ISODateTimeEncoder.encoder();
        }
        if (SQL_TIMESTAMP.equals(javaType)) {
            return ISODateTimeEncoder.encoder();
        }
        if (SQL_DATE.equals(javaType)) {
            return ISODateEncoder.encoder();
        }
        if (SQL_TIME.equals(javaType)) {
            return ISOTimeEncoder.encoder();
        }
        return GenericEncoder.encoder();
    }
}

