/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.constraints;

import com.nhl.link.rest.EntityUpdate;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.constraints.ConstrainedLrEntity;
import com.nhl.link.rest.constraints.Constraint;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.runtime.processor.update.UpdateContext;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestConstraintsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestConstraintsHandler.class);

    RequestConstraintsHandler() {
    }

    <T> boolean constrainResponse(ResourceEntity<T> resourceEntity, Constraint<T> c) {
        if (resourceEntity == null) {
            return true;
        }
        if (c == null) {
            return false;
        }
        this.applyForRead(resourceEntity, (ConstrainedLrEntity)c.apply(resourceEntity.getLrEntity()));
        return true;
    }

    <T> boolean constrainUpdate(UpdateContext<T> context, Constraint<T> c) {
        if (context.getUpdates().isEmpty()) {
            return true;
        }
        if (c == null) {
            return false;
        }
        this.applyForWrite(context, (ConstrainedLrEntity)c.apply(context.getEntity().getLrEntity()));
        return true;
    }

    private void applyForWrite(UpdateContext<?> context, ConstrainedLrEntity constraints) {
        if (!constraints.isIdIncluded()) {
            context.setIdUpdatesDisallowed(true);
        }
        for (EntityUpdate<?> u : context.getUpdates()) {
            Iterator<Map.Entry<String, Object>> it = u.getValues().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> e = it.next();
                if (constraints.hasAttribute(e.getKey())) continue;
                if (!context.getEntity().isDefault(e.getKey())) {
                    LOGGER.info("Attribute not allowed, removing: " + e.getKey() + " for id " + u.getId());
                }
                it.remove();
            }
            Iterator<String> it2 = u.getRelatedIds().keySet().iterator();
            while (it2.hasNext()) {
                String relationship = it2.next();
                if (constraints.hasChild(relationship)) continue;
                LOGGER.info("Relationship not allowed, removing: " + relationship + " for id " + u.getId());
                it2.remove();
            }
        }
    }

    private void applyForRead(ResourceEntity<?> target, ConstrainedLrEntity constraints) {
        if (!constraints.isIdIncluded()) {
            target.excludeId();
        }
        Iterator<LrAttribute> ait = target.getAttributes().values().iterator();
        while (ait.hasNext()) {
            LrAttribute a = ait.next();
            if (constraints.hasAttribute(a.getName())) continue;
            if (!target.isDefault(a.getName())) {
                LOGGER.info("Attribute not allowed, removing: " + a);
            }
            ait.remove();
        }
        Iterator<Map.Entry<String, ResourceEntity<?>>> rit = target.getChildren().entrySet().iterator();
        while (rit.hasNext()) {
            Map.Entry<String, ResourceEntity<?>> e = rit.next();
            ConstrainedLrEntity sourceChild = constraints.getChild(e.getKey());
            if (sourceChild != null) {
                this.applyForRead(e.getValue(), sourceChild);
                continue;
            }
            if (!target.isDefault(e.getKey())) {
                LOGGER.info("Relationship not allowed, removing: " + e.getKey());
            }
            rit.remove();
        }
        if (constraints.getQualifier() != null) {
            target.andQualifier(constraints.getQualifier());
        }
        if (target.getMapByPath() != null && !this.allowedMapBy(constraints, target.getMapByPath())) {
            LOGGER.info("'mapBy' not allowed, removing: " + target.getMapByPath());
            target.mapBy(null, null);
        }
    }

    private boolean allowedMapBy(ConstrainedLrEntity source, String path) {
        int dot = path.indexOf(46);
        if (dot == 0) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Path starts with dot: " + path);
        }
        if (dot == path.length() - 1) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Path ends with dot: " + path);
        }
        if (dot > 0) {
            String property = path.substring(0, dot);
            ConstrainedLrEntity child = source.getChild(property);
            return child != null && this.allowedMapBy(child, path.substring(dot + 1));
        }
        return this.allowedMapBy_LastComponent(source, path);
    }

    private boolean allowedMapBy_LastComponent(ConstrainedLrEntity source, String path) {
        String property = path;
        if (property == null || property.length() == 0 || property.equals("id")) {
            return source.isIdIncluded();
        }
        if (source.hasAttribute(property)) {
            return true;
        }
        ConstrainedLrEntity child = source.getChild(property);
        return child != null && this.allowedMapBy_LastComponent(child, null);
    }
}

