/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.constraints;

import com.nhl.link.rest.EntityConstraint;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.runtime.constraints.AllowAllEntityConstraint;
import com.nhl.link.rest.runtime.constraints.DefaultEntityConstraint;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.core.Response;

abstract class EntityConstraintSource {
    private ConcurrentMap<String, EntityConstraint> constraints;

    EntityConstraintSource(ConcurrentMap<String, EntityConstraint> constraints) {
        this.constraints = constraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntityConstraint getOrCreate(LrEntity<?> entity) {
        EntityConstraint c = (EntityConstraint)this.constraints.get(entity.getName());
        if (c == null) {
            LrEntity<?> lrEntity = entity;
            synchronized (lrEntity) {
                c = (EntityConstraint)this.constraints.get(entity.getName());
                if (c == null) {
                    c = this.create(entity);
                    this.constraints.put(entity.getName(), c);
                }
            }
        }
        return c;
    }

    protected abstract AnnotationData processAnnotation(Class<?> var1);

    private EntityConstraint create(LrEntity<?> entity) {
        AnnotationData ad = this.processAnnotation(entity.getType());
        if (ad == null) {
            return AllowAllEntityConstraint.instance();
        }
        HashSet<String> attributes = new HashSet<String>();
        HashSet<String> relationships = new HashSet<String>();
        for (String p : ad.properties) {
            LrAttribute a = entity.getAttribute(p);
            if (a != null) {
                attributes.add(p);
                continue;
            }
            LrRelationship r = entity.getRelationship(p);
            if (r != null) {
                relationships.add(p);
                continue;
            }
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Invalid property: " + entity.getName() + "." + p);
        }
        boolean allowsAllAttributes = attributes.size() == entity.getAttributes().size();
        return new DefaultEntityConstraint(entity.getName(), ad.id, allowsAllAttributes, attributes, relationships);
    }

    class AnnotationData {
        boolean id;
        String[] properties;

        AnnotationData(boolean id, String[] properties) {
            this.id = id;
            this.properties = properties;
        }
    }
}

