/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.constraints;

import com.nhl.link.rest.EntityConstraint;
import com.nhl.link.rest.EntityUpdate;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.annotation.ClientReadable;
import com.nhl.link.rest.annotation.ClientWritable;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.runtime.constraints.EntityConstraintSource;
import com.nhl.link.rest.runtime.processor.update.UpdateContext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntityConstraintHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityConstraintHandler.class);
    private EntityConstraintSource forRead;
    private EntityConstraintSource forWrite;

    EntityConstraintHandler(List<EntityConstraint> defaultReadConstraints, List<EntityConstraint> defaultWriteConstraints) {
        ConcurrentHashMap<String, EntityConstraint> readMap = new ConcurrentHashMap<String, EntityConstraint>();
        for (EntityConstraint c : defaultReadConstraints) {
            readMap.put(c.getEntityName(), c);
        }
        ConcurrentHashMap<String, EntityConstraint> writeMap = new ConcurrentHashMap<String, EntityConstraint>();
        for (EntityConstraint c : defaultWriteConstraints) {
            writeMap.put(c.getEntityName(), c);
        }
        this.forRead = new EntityConstraintSource(readMap){

            @Override
            protected EntityConstraintSource.AnnotationData processAnnotation(Class<?> type) {
                ClientReadable a = type.getAnnotation(ClientReadable.class);
                if (a == null) {
                    return null;
                }
                return new EntityConstraintSource.AnnotationData(this, a.id(), a.value());
            }
        };
        this.forWrite = new EntityConstraintSource(writeMap){

            @Override
            protected EntityConstraintSource.AnnotationData processAnnotation(Class<?> type) {
                ClientWritable a = type.getAnnotation(ClientWritable.class);
                if (a == null) {
                    return null;
                }
                return new EntityConstraintSource.AnnotationData(this, a.id(), a.value());
            }
        };
    }

    void constrainResponse(ResourceEntity<?> resourceEntity) {
        this.constrainForRead(resourceEntity);
    }

    void constrainUpdate(UpdateContext<?> context) {
        Iterator<String> it;
        EntityConstraint c = this.forWrite.getOrCreate(context.getEntity().getLrEntity());
        if (!c.allowsId()) {
            context.setIdUpdatesDisallowed(true);
        }
        if (!c.allowsAllAttributes()) {
            for (EntityUpdate<?> u : context.getUpdates()) {
                it = u.getValues().keySet().iterator();
                while (it.hasNext()) {
                    String attr = it.next();
                    if (c.allowsAttribute(attr)) continue;
                    if (!context.getEntity().isDefault(attr)) {
                        LOGGER.info("Attribute not allowed, removing: " + attr + " for id " + u.getId());
                    }
                    it.remove();
                }
            }
        }
        for (EntityUpdate<?> u : context.getUpdates()) {
            it = u.getRelatedIds().keySet().iterator();
            while (it.hasNext()) {
                String relationship = it.next();
                if (c.allowsRelationship(relationship)) continue;
                LOGGER.info("Relationship not allowed, removing: " + relationship + " for id " + u.getId());
                it.remove();
            }
        }
    }

    void constrainForRead(ResourceEntity<?> entity) {
        EntityConstraint c = this.forRead.getOrCreate(entity.getLrEntity());
        if (!c.allowsId()) {
            entity.excludeId();
        }
        if (!c.allowsAllAttributes()) {
            Iterator<LrAttribute> ait = entity.getAttributes().values().iterator();
            while (ait.hasNext()) {
                String a = ait.next().getName();
                if (c.allowsAttribute(a)) continue;
                if (!entity.isDefault(a)) {
                    LOGGER.info("Attribute not allowed, removing: " + a);
                }
                ait.remove();
            }
        }
        Iterator<Map.Entry<String, ResourceEntity<?>>> rit = entity.getChildren().entrySet().iterator();
        while (rit.hasNext()) {
            Map.Entry<String, ResourceEntity<?>> e = rit.next();
            if (c.allowsRelationship(e.getKey())) {
                this.constrainForRead(e.getValue());
                continue;
            }
            if (!entity.isDefault(e.getKey())) {
                LOGGER.info("Relationship not allowed, removing: " + e.getKey());
            }
            rit.remove();
        }
    }
}

