/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.constraints;

import com.nhl.link.rest.EntityConstraint;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.SizeConstraints;
import com.nhl.link.rest.constraints.Constraint;
import com.nhl.link.rest.runtime.constraints.EntityConstraintHandler;
import com.nhl.link.rest.runtime.constraints.IConstraintsHandler;
import com.nhl.link.rest.runtime.constraints.RequestConstraintsHandler;
import com.nhl.link.rest.runtime.processor.update.UpdateContext;
import java.util.List;
import org.apache.cayenne.di.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintsHandler
implements IConstraintsHandler {
    public static final String DEFAULT_READ_CONSTRAINTS_LIST = "linkrest.constraints.read.list";
    public static final String DEFAULT_WRITE_CONSTRAINTS_LIST = "linkrest.constraints.write.list";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstraintsHandler.class);
    private RequestConstraintsHandler treeConstraintsHandler = new RequestConstraintsHandler();
    private EntityConstraintHandler entityConstraintHandler;

    public ConstraintsHandler(@Inject(value="linkrest.constraints.read.list") List<EntityConstraint> readConstraints, @Inject(value="linkrest.constraints.write.list") List<EntityConstraint> writeConstraints) {
        this.entityConstraintHandler = new EntityConstraintHandler(readConstraints, writeConstraints);
    }

    @Override
    public <T> void constrainUpdate(UpdateContext<T> context, Constraint<T> c) {
        if (!this.treeConstraintsHandler.constrainUpdate(context, c)) {
            this.entityConstraintHandler.constrainUpdate(context);
        }
    }

    @Override
    public <T> void constrainResponse(ResourceEntity<T> entity, SizeConstraints sizeConstraints, Constraint<T> c) {
        if (sizeConstraints != null) {
            this.applySizeConstraintsForRead(entity, sizeConstraints);
        }
        if (!this.treeConstraintsHandler.constrainResponse(entity, c)) {
            this.entityConstraintHandler.constrainResponse(entity);
        }
    }

    protected void applySizeConstraintsForRead(ResourceEntity<?> entity, SizeConstraints constraints) {
        int upperLimit;
        int upperOffset = constraints.getFetchOffset();
        if (upperOffset > 0 && entity.getFetchOffset() > upperOffset) {
            LOGGER.info("Reducing fetch offset from " + entity.getFetchOffset() + " to max allowed value of " + upperOffset);
            entity.setFetchOffset(upperOffset);
        }
        if ((upperLimit = constraints.getFetchLimit()) > 0 && entity.getFetchLimit() > upperLimit) {
            LOGGER.info("Reducing fetch limit from " + entity.getFetchLimit() + " to max allowed value of " + upperLimit);
            entity.setFetchLimit(upperLimit);
        }
    }
}

