/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.cayenne.processor.update;

import com.nhl.link.rest.EntityUpdate;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.ObjectMapper;
import com.nhl.link.rest.ObjectMapperFactory;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.runtime.cayenne.ByIdObjectMapperFactory;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneUpdateDataStoreStage;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneUpdateStartStage;
import com.nhl.link.rest.runtime.meta.IMetadataService;
import com.nhl.link.rest.runtime.processor.update.UpdateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.query.SelectQuery;

public class CayenneUpdateStage
extends CayenneUpdateDataStoreStage {
    public CayenneUpdateStage(@Inject IMetadataService metadataService) {
        super(metadataService);
    }

    @Override
    protected <T extends DataObject> void sync(UpdateContext<T> context) {
        ObjectMapper<DataObject> mapper = this.createObjectMapper(context);
        Map<Object, Collection<EntityUpdate<T>>> keyMap = this.mutableKeyMap(context, mapper);
        for (DataObject o : this.itemsForKeys(context, keyMap.keySet(), mapper)) {
            Object key = mapper.keyForObject(o);
            Collection<EntityUpdate<T>> updates = keyMap.remove(key);
            if (updates == null) {
                throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Invalid key item: " + key);
            }
            this.updateSingle(context, o, updates);
        }
        this.afterUpdatesMerge(context, keyMap);
    }

    protected <T extends DataObject> void afterUpdatesMerge(UpdateContext<T> context, Map<Object, Collection<EntityUpdate<T>>> keyMap) {
        if (!keyMap.isEmpty()) {
            Object firstKey = keyMap.keySet().iterator().next();
            if (firstKey == null) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Can't update. No id for object");
            }
            LrEntity<T> entity = context.getEntity().getLrEntity();
            throw new LinkRestException(Response.Status.NOT_FOUND, "No object for ID '" + firstKey + "' and entity '" + entity.getName() + "'");
        }
    }

    protected <T extends DataObject> Map<Object, Collection<EntityUpdate<T>>> mutableKeyMap(UpdateContext<T> context, ObjectMapper<T> mapper) {
        Collection<EntityUpdate<T>> updates = context.getUpdates();
        HashMap<Object, Collection<EntityUpdate<T>>> map = new HashMap<Object, Collection<EntityUpdate<T>>>((int)((double)updates.size() / 0.75));
        for (EntityUpdate<T> u : updates) {
            Object key = mapper.keyForUpdate(u);
            ArrayList<EntityUpdate<T>> updatesForKey = (ArrayList<EntityUpdate<T>>)map.get(key);
            if (updatesForKey == null) {
                updatesForKey = new ArrayList<EntityUpdate<T>>(2);
                map.put(key, updatesForKey);
            }
            updatesForKey.add(u);
        }
        return map;
    }

    protected <T extends DataObject> ObjectMapper<T> createObjectMapper(UpdateContext<T> context) {
        ObjectMapperFactory mapper = context.getMapper() != null ? context.getMapper() : ByIdObjectMapperFactory.mapper();
        return mapper.createMapper(context);
    }

    <T extends DataObject> List<T> itemsForKeys(UpdateContext<T> context, Collection<Object> keys, ObjectMapper<T> mapper) {
        ArrayList<Expression> expressions = new ArrayList<Expression>(keys.size());
        for (Object key : keys) {
            Expression e = mapper.expressionForKey(key);
            if (e == null) continue;
            expressions.add(e);
        }
        if (expressions.isEmpty()) {
            return Collections.emptyList();
        }
        SelectQuery query = SelectQuery.query(context.getType());
        query.setQualifier(ExpressionFactory.joinExp((int)1, expressions));
        List objects = CayenneUpdateStartStage.cayenneContext(context).select((Select)query);
        if (context.isById() && objects.size() > 1) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Found more than one object for ID '%s' and entity '%s'", context.getId(), context.getEntity().getLrEntity().getName()));
        }
        return objects;
    }
}

