/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.cayenne.processor.update;

import com.nhl.link.rest.EntityUpdate;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.ObjectMapper;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneIdempotentCreateOrUpdateStage;
import com.nhl.link.rest.runtime.cayenne.processor.update.CayenneUpdateStartStage;
import com.nhl.link.rest.runtime.meta.IMetadataService;
import com.nhl.link.rest.runtime.processor.update.UpdateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.query.SelectQuery;

public class CayenneIdempotentFullSyncStage
extends CayenneIdempotentCreateOrUpdateStage {
    public CayenneIdempotentFullSyncStage(@Inject IMetadataService metadataService) {
        super(metadataService);
    }

    @Override
    protected <T extends DataObject> void sync(UpdateContext<T> context) {
        ObjectMapper<DataObject> mapper = this.createObjectMapper(context);
        Map<Object, Collection<EntityUpdate<T>>> keyMap = this.mutableKeyMap(context, mapper);
        List<T> allObjects = this.allItems(context);
        ArrayList<DataObject> deletedObjects = new ArrayList<DataObject>();
        for (DataObject o : allObjects) {
            Object key = mapper.keyForObject(o);
            Collection<EntityUpdate<T>> updates = keyMap.remove(key);
            if (updates == null) {
                deletedObjects.add(o);
                continue;
            }
            this.updateSingle(context, o, updates);
        }
        if (!deletedObjects.isEmpty()) {
            CayenneUpdateStartStage.cayenneContext(context).deleteObjects(deletedObjects);
        }
        this.afterUpdatesMerge(context, keyMap);
    }

    <T extends DataObject> List<T> allItems(UpdateContext<T> context) {
        SelectQuery query = SelectQuery.query(context.getType());
        if (context.getParent() != null) {
            EntityResolver resolver = CayenneUpdateStartStage.cayenneContext(context).getEntityResolver();
            query.andQualifier(context.getParent().qualifier(resolver));
        }
        if (context.getEntity().getQualifier() != null) {
            query.andQualifier(context.getEntity().getQualifier());
        }
        List objects = CayenneUpdateStartStage.cayenneContext(context).select((Select)query);
        if (context.isById() && objects.size() > 1) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Found more than one object for ID '%s' and entity '%s'", context.getId(), context.getEntity().getLrEntity().getName()));
        }
        return objects;
    }
}

