/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.cayenne.processor.update;

import com.nhl.link.rest.EntityUpdate;
import com.nhl.link.rest.processor.Processor;
import com.nhl.link.rest.processor.ProcessorOutcome;
import com.nhl.link.rest.runtime.processor.update.UpdateContext;
import java.util.ArrayList;
import java.util.HashSet;
import javax.ws.rs.core.Response;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectId;

public class CayenneFillResponseStage
implements Processor<UpdateContext<?>> {
    private Response.Status status;

    public CayenneFillResponseStage(Response.Status status) {
        this.status = status;
    }

    @Override
    public ProcessorOutcome execute(UpdateContext<?> context) {
        this.doExecute(context);
        return ProcessorOutcome.CONTINUE;
    }

    protected <T extends DataObject> void doExecute(UpdateContext<T> context) {
        context.setStatus(this.status);
        if (context.isIncludingDataInResponse()) {
            ArrayList<DataObject> objects = new ArrayList<DataObject>(context.getUpdates().size());
            HashSet<ObjectId> seen = new HashSet<ObjectId>();
            for (EntityUpdate<T> u : context.getUpdates()) {
                DataObject o = (DataObject)u.getMergedTo();
                if (o == null || !seen.add(o.getObjectId())) continue;
                objects.add(o);
            }
            context.setObjects(objects);
        }
    }
}

