/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.cayenne.processor.unrelate;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.processor.Processor;
import com.nhl.link.rest.processor.ProcessorOutcome;
import com.nhl.link.rest.runtime.cayenne.processor.unrelate.CayenneUnrelateStartStage;
import com.nhl.link.rest.runtime.meta.IMetadataService;
import com.nhl.link.rest.runtime.processor.unrelate.UnrelateContext;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;

public class CayenneUnrelateDataStoreStage
implements Processor<UnrelateContext<?>> {
    private IMetadataService metadataService;

    public CayenneUnrelateDataStoreStage(@Inject IMetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @Override
    public ProcessorOutcome execute(UnrelateContext<?> context) {
        this.doExecute(context);
        return ProcessorOutcome.CONTINUE;
    }

    protected <T extends DataObject> void doExecute(UnrelateContext<T> context) {
        ObjectContext cayenneContext = CayenneUnrelateStartStage.cayenneContext(context);
        if (context.getId() != null) {
            this.unrelateSingle(context, cayenneContext);
        } else {
            this.unrelateAll(context, cayenneContext);
        }
    }

    private <T extends DataObject> void unrelateSingle(UnrelateContext<T> context, ObjectContext cayenneContext) {
        LrRelationship relationship = this.metadataService.getLrRelationship(context.getParent());
        DataObject parent = (DataObject)this.getExistingObject(context.getParent().getType(), cayenneContext, context.getParent().getId().get());
        Class<?> childType = relationship.getTargetEntity().getType();
        DataObject child = (DataObject)this.getExistingObject(childType, cayenneContext, context.getId());
        if (relationship.isToMany()) {
            Collection relatedCollection = (Collection)parent.readProperty(relationship.getName());
            if (!relatedCollection.contains(child)) {
                throw new LinkRestException(Response.Status.EXPECTATION_FAILED, "Source and target are not related");
            }
            parent.removeToManyTarget(relationship.getName(), child, true);
        } else {
            if (parent.readProperty(relationship.getName()) != child) {
                throw new LinkRestException(Response.Status.EXPECTATION_FAILED, "Source and target are not related");
            }
            parent.setToOneTarget(relationship.getName(), null, true);
        }
        cayenneContext.commitChanges();
    }

    private <T extends DataObject> void unrelateAll(UnrelateContext<T> context, ObjectContext cayenneContext) {
        LrRelationship lrRelationship = this.metadataService.getLrRelationship(context.getParent());
        DataObject parent = (DataObject)this.getExistingObject(context.getParent().getType(), cayenneContext, context.getParent().getId().get());
        if (lrRelationship.isToMany()) {
            ArrayList relatedCollection = new ArrayList((Collection)parent.readProperty(lrRelationship.getName()));
            for (DataObject o : relatedCollection) {
                parent.removeToManyTarget(lrRelationship.getName(), o, true);
            }
        } else {
            DataObject target = (DataObject)parent.readProperty(lrRelationship.getName());
            if (target != null) {
                parent.setToOneTarget(lrRelationship.getName(), null, true);
            }
        }
        cayenneContext.commitChanges();
    }

    private Object getExistingObject(Class<?> type, ObjectContext context, Object id) {
        Object object = this.getOptionalExistingObject(type, context, id);
        if (object == null) {
            ObjEntity entity = context.getEntityResolver().getObjEntity(type);
            throw new LinkRestException(Response.Status.NOT_FOUND, "No object for ID '" + id + "' and entity '" + entity.getName() + "'");
        }
        return object;
    }

    private Object getOptionalExistingObject(Class<?> type, ObjectContext context, Object id) {
        ObjEntity entity = context.getEntityResolver().getObjEntity(type);
        if (entity == null) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Unknown entity class: " + type);
        }
        String idName = (String)entity.getPrimaryKeyNames().iterator().next();
        ObjectIdQuery select = new ObjectIdQuery(new ObjectId(entity.getName(), idName, id));
        return Cayenne.objectForQuery((ObjectContext)context, (Query)select);
    }
}

