/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.cayenne.processor.select;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.LrObjectId;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.meta.LrPersistentAttribute;
import com.nhl.link.rest.meta.LrPersistentEntity;
import com.nhl.link.rest.processor.Processor;
import com.nhl.link.rest.processor.ProcessorOutcome;
import com.nhl.link.rest.runtime.cayenne.ICayennePersister;
import com.nhl.link.rest.runtime.processor.select.SelectContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SelectQuery;

public class CayenneAssembleQueryStage
implements Processor<SelectContext<?>> {
    private EntityResolver entityResolver;

    public CayenneAssembleQueryStage(@Inject ICayennePersister persister) {
        this.entityResolver = persister.entityResolver();
    }

    @Override
    public ProcessorOutcome execute(SelectContext<?> context) {
        this.doExecute(context);
        return ProcessorOutcome.CONTINUE;
    }

    protected <T> void doExecute(SelectContext<T> context) {
        context.setSelect(this.buildQuery(context));
    }

    <T> SelectQuery<T> buildQuery(SelectContext<T> context) {
        int limit;
        ResourceEntity<T> entity = context.getEntity();
        SelectQuery<T> query = this.basicSelect(context);
        if (!entity.isFiltered() && (limit = context.getEntity().getFetchLimit()) > 0) {
            query.setPageSize(limit);
        }
        if (context.getParent() != null) {
            Expression qualifier = context.getParent().qualifier(this.entityResolver);
            query.andQualifier(qualifier);
        }
        if (entity.getQualifier() != null) {
            query.andQualifier(entity.getQualifier());
        }
        for (Ordering o : entity.getOrderings()) {
            query.addOrdering(o);
        }
        if (!entity.getChildren().isEmpty()) {
            PrefetchTreeNode root = new PrefetchTreeNode();
            int prefetchSemantics = context.getPrefetchSemantics();
            if (prefetchSemantics <= 0) {
                prefetchSemantics = context.isById() && context.getId().size() == 1 ? 1 : 2;
            }
            this.appendPrefetches(root, entity, prefetchSemantics);
            query.setPrefetchTree(root);
        }
        return query;
    }

    <T> SelectQuery<T> basicSelect(SelectContext<T> context) {
        if (context.isById()) {
            Class root = context.getType();
            SelectQuery query = new SelectQuery(root);
            query.andQualifier(this.buildIdQualifer(context.getEntity().getLrEntity(), context.getId()));
            return query;
        }
        return context.getSelect() != null ? context.getSelect() : new SelectQuery(context.getType());
    }

    private Expression buildIdQualifer(LrEntity<?> entity, LrObjectId id) {
        Collection<LrAttribute> idAttributes = entity.getIds();
        if (idAttributes.size() != id.size()) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "Wrong ID size: expected " + idAttributes.size() + ", got: " + id.size());
        }
        ArrayList<Expression> qualifiers = new ArrayList<Expression>();
        for (LrAttribute idAttribute : idAttributes) {
            Object idValue = id.get(idAttribute.getName());
            if (idValue == null) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "Failed to build a Cayenne qualifier for entity " + entity.getName() + ": one of the entity's ID parts is missing in this ID: " + idAttribute.getName());
            }
            if (idAttribute instanceof LrPersistentAttribute) {
                qualifiers.add(ExpressionFactory.matchDbExp((String)((LrPersistentAttribute)idAttribute).getColumnName(), (Object)idValue));
                continue;
            }
            qualifiers.add(ExpressionFactory.matchDbExp((String)idAttribute.getName(), (Object)idValue));
        }
        return ExpressionFactory.and(qualifiers);
    }

    private void appendPrefetches(PrefetchTreeNode root, ResourceEntity<?> entity, int prefetchSemantics) {
        for (Map.Entry<String, ResourceEntity<?>> e : entity.getChildren().entrySet()) {
            if (!(e.getValue().getLrEntity() instanceof LrPersistentEntity)) continue;
            PrefetchTreeNode child = root.addPath(e.getKey());
            child.setPhantom(false);
            child.setSemantics(prefetchSemantics);
            this.appendPrefetches(child, e.getValue(), prefetchSemantics);
        }
        if (entity.getMapBy() != null) {
            this.appendPrefetches(root, entity.getMapBy(), prefetchSemantics);
        }
    }
}

