/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.cayenne.processor.delete;

import com.nhl.link.rest.EntityParent;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.LrObjectId;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.processor.Processor;
import com.nhl.link.rest.processor.ProcessorOutcome;
import com.nhl.link.rest.runtime.cayenne.processor.Util;
import com.nhl.link.rest.runtime.cayenne.processor.delete.CayenneDeleteStartStage;
import com.nhl.link.rest.runtime.meta.IMetadataService;
import com.nhl.link.rest.runtime.processor.delete.DeleteContext;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.query.SelectQuery;

public class CayenneDeleteStage
implements Processor<DeleteContext<?>> {
    private IMetadataService metadataService;

    public CayenneDeleteStage(@Inject IMetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @Override
    public ProcessorOutcome execute(DeleteContext<?> context) {
        this.doExecute(context);
        return ProcessorOutcome.CONTINUE;
    }

    protected <T extends DataObject> void doExecute(DeleteContext<T> context) {
        ObjectContext cayenneContext = CayenneDeleteStartStage.cayenneContext(context);
        if (context.isById()) {
            LrEntity lrEntity = this.metadataService.getLrEntity(context.getType());
            this.deleteById(context, cayenneContext, lrEntity);
        } else if (context.getParent() != null) {
            LrEntity<?> parentLrEntity = this.metadataService.getLrEntity(context.getParent().getType());
            this.deleteByParent(context, cayenneContext, parentLrEntity);
        } else {
            this.deleteAll(context, cayenneContext);
        }
    }

    private <T extends DataObject> void deleteById(DeleteContext<T> context, ObjectContext cayenneContext, LrEntity<T> lrEntity) {
        for (LrObjectId id : context.getIds()) {
            Object o = Util.findById(cayenneContext, context.getType(), lrEntity, id.get());
            if (o == null) {
                ObjEntity entity = cayenneContext.getEntityResolver().getObjEntity(context.getType());
                throw new LinkRestException(Response.Status.NOT_FOUND, "No object for ID '" + id + "' and entity '" + entity.getName() + "'");
            }
            cayenneContext.deleteObject(o);
        }
        cayenneContext.commitChanges();
    }

    private <T extends DataObject> void deleteByParent(DeleteContext<T> context, ObjectContext cayenneContext, LrEntity<?> lrParentEntity) {
        EntityParent<?> parent = context.getParent();
        Object parentObject = Util.findById(cayenneContext, parent.getType(), lrParentEntity, parent.getId().get());
        if (parentObject == null) {
            ObjEntity entity = cayenneContext.getEntityResolver().getObjEntity(parent.getType());
            throw new LinkRestException(Response.Status.NOT_FOUND, "No parent object for ID '" + parent.getId() + "' and entity '" + entity.getName() + "'");
        }
        Expression qualifier = parent.qualifier(cayenneContext.getEntityResolver());
        SelectQuery select = SelectQuery.query(context.getType());
        select.andQualifier(qualifier);
        List objects = cayenneContext.select((Select)select);
        cayenneContext.deleteObjects((Collection)objects);
        cayenneContext.commitChanges();
    }

    private <T extends DataObject> void deleteAll(DeleteContext<?> context, ObjectContext cayenneContext) {
        ObjEntity e = cayenneContext.getEntityResolver().getObjEntity(context.getType());
        cayenneContext.performQuery((Query)new EJBQLQuery("delete from " + e.getName()));
    }
}

