/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.cayenne.processor;

import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrAttribute;
import com.nhl.link.rest.meta.LrEntity;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectSelect;

public final class Util {
    private Util() {
    }

    public static <A> A findById(ObjectContext context, Class<A> type, LrEntity<?> lrEntity, Object id) {
        ObjEntity entity = context.getEntityResolver().getObjEntity(type);
        if (entity == null) {
            throw new LinkRestException(Response.Status.INTERNAL_SERVER_ERROR, "Unknown entity class: " + type);
        }
        if (id == null) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "No id specified");
        }
        if (id instanceof Map) {
            Map ids = (Map)id;
            ObjectSelect query = ObjectSelect.query(type);
            for (Map.Entry entry : ids.entrySet()) {
                query.and(new Expression[]{ExpressionFactory.matchDbExp((String)entity.getDbEntity().getAttribute((String)entry.getKey()).getName(), entry.getValue())});
            }
            return (A)query.selectOne(context);
        }
        LrAttribute attribute = lrEntity.getIds().iterator().next();
        return (A)ObjectSelect.query(type, (Expression)new ASTEqual((SimpleNode)attribute.getPathExp(), id)).selectOne(context);
    }
}

