/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.cayenne;

import com.nhl.link.rest.EntityUpdate;
import com.nhl.link.rest.ObjectMapper;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;

class ByKeyObjectMapper<T>
implements ObjectMapper<T> {
    private String keyProperty;

    ByKeyObjectMapper(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    @Override
    public Object keyForObject(T object) {
        return ((DataObject)object).readProperty(this.keyProperty);
    }

    @Override
    public Object keyForUpdate(EntityUpdate<T> u) {
        return u.getValues().get(this.keyProperty);
    }

    @Override
    public Expression expressionForKey(Object key) {
        return ExpressionFactory.matchExp((String)this.keyProperty, (Object)key);
    }
}

