/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.cayenne;

import com.nhl.link.rest.EntityUpdate;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.ObjectMapper;
import com.nhl.link.rest.property.DataObjectPropertyReader;
import com.nhl.link.rest.property.PersistentObjectIdPropertyReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.parser.SimpleNode;

class ByIdObjectMapper<T>
implements ObjectMapper<T> {
    private ASTPath[] keyPaths;

    ByIdObjectMapper(ASTPath[] keyPaths) {
        this.keyPaths = keyPaths;
    }

    @Override
    public Expression expressionForKey(Object key) {
        if (key == null) {
            return null;
        }
        Map idMap = (Map)key;
        if (idMap.isEmpty()) {
            return null;
        }
        int len = this.keyPaths.length;
        if (len == 1) {
            return this.match(this.keyPaths[0], idMap);
        }
        ArrayList<Expression> exps = new ArrayList<Expression>(len);
        for (ASTPath p : this.keyPaths) {
            exps.add(this.match(p, idMap));
        }
        return ExpressionFactory.joinExp((int)0, exps);
    }

    private Expression match(ASTPath path, Map<String, Object> idMap) {
        Object value = idMap.get(path.getPath());
        if (value == null) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "No ID value for path: " + path);
        }
        return new ASTEqual((SimpleNode)path, value);
    }

    @Override
    public Object keyForObject(T object) {
        HashMap<String, Object> idMap = new HashMap<String, Object>();
        for (ASTPath keyPath : this.keyPaths) {
            idMap.put(keyPath.getPath(), this.readPropertyOrId(object, keyPath.getPath()));
        }
        return idMap;
    }

    private Object readPropertyOrId(Object object, String name) {
        Object property = DataObjectPropertyReader.reader().value(object, name);
        return property == null ? PersistentObjectIdPropertyReader.reader().value(object, name) : property;
    }

    @Override
    public Object keyForUpdate(EntityUpdate<T> update) {
        return update.getId();
    }
}

