/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.adapter.sencha;

import com.fasterxml.jackson.databind.JsonNode;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.parser.converter.GenericConverter;
import com.nhl.link.rest.runtime.jackson.IJacksonService;
import com.nhl.link.rest.runtime.parser.EntityJsonTraverser;
import com.nhl.link.rest.runtime.parser.EntityJsonVisitor;
import com.nhl.link.rest.runtime.parser.UpdateParser;
import com.nhl.link.rest.runtime.parser.converter.IJsonValueConverterFactory;
import com.nhl.link.rest.runtime.semantics.IRelationshipMapper;
import java.util.regex.Pattern;
import org.apache.cayenne.di.Inject;

public class SenchaUpdateParser
extends UpdateParser {
    private static final Pattern DASH_ID_PATTERN = Pattern.compile(".-[\\d]+$");
    private EntityJsonTraverser senchaEntityJsonTraverser;

    public SenchaUpdateParser(@Inject IRelationshipMapper relationshipMapper, @Inject IJacksonService jacksonService, @Inject IJsonValueConverterFactory converterFactory) {
        super(relationshipMapper, jacksonService, converterFactory);
        this.senchaEntityJsonTraverser = new SenchaEntityJsonTraverser(relationshipMapper, converterFactory);
    }

    protected boolean isTempId(Object value) {
        String idString;
        return value instanceof String && DASH_ID_PATTERN.matcher(idString = (String)value).find();
    }

    @Override
    protected EntityJsonTraverser entityJsonTraverser() {
        return this.senchaEntityJsonTraverser;
    }

    private class SenchaEntityJsonTraverser
    extends EntityJsonTraverser {
        public SenchaEntityJsonTraverser(IRelationshipMapper relationshipMapper, IJsonValueConverterFactory converterFactory) {
            super(relationshipMapper, converterFactory);
        }

        @Override
        protected void extractPK(LrEntity<?> entity, EntityJsonVisitor visitor, JsonNode valueNode) {
            Object value = GenericConverter.converter().value(valueNode);
            if (!SenchaUpdateParser.this.isTempId(value)) {
                super.extractPK(entity, visitor, valueNode);
            }
        }
    }
}

