/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.adapter.sencha;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.nhl.link.rest.LinkRestException;
import com.nhl.link.rest.meta.LrEntity;
import com.nhl.link.rest.runtime.adapter.sencha.ISenchaFilterProcessor;
import com.nhl.link.rest.runtime.jackson.IJacksonService;
import com.nhl.link.rest.runtime.parser.cache.IPathCache;
import com.nhl.link.rest.runtime.parser.filter.FilterUtil;
import com.nhl.link.rest.runtime.parser.filter.IExpressionPostProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTObjPath;

public class SenchaFilterProcessor
implements ISenchaFilterProcessor {
    private static final int MAX_VALUE_LENGTH = 1024;
    private static final String EXACT_MATCH = "exactMatch";
    private static final String PROPERTY = "property";
    private static final String VALUE = "value";
    private static final String DISABLED = "disabled";
    private static final String OPERATOR = "operator";
    private IJacksonService jsonParser;
    private IPathCache pathCache;
    private IExpressionPostProcessor postProcessor;

    public SenchaFilterProcessor(@Inject IJacksonService jsonParser, @Inject IPathCache pathCache, @Inject IExpressionPostProcessor postProcessor) {
        this.jsonParser = jsonParser;
        this.pathCache = pathCache;
        this.postProcessor = postProcessor;
    }

    @Override
    public Expression process(LrEntity<?> entity, String filtersJson) {
        if (filtersJson == null || filtersJson.length() == 0) {
            return null;
        }
        JsonNode rootNode = this.jsonParser.parseJson(filtersJson);
        if (rootNode == null) {
            return null;
        }
        Expression combined = null;
        for (JsonNode filterNode : rootNode) {
            Expression qualifier;
            JsonNode operatorNode;
            String operator;
            JsonNode propertyNode = filterNode.get(PROPERTY);
            if (propertyNode == null) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "filter 'property' is missing" + filterNode.asText());
            }
            JsonNode valueNode = filterNode.get(VALUE);
            if (valueNode == null) {
                throw new LinkRestException(Response.Status.BAD_REQUEST, "filter 'value' is missing" + filterNode.asText());
            }
            JsonNode disabledNode = filterNode.get(DISABLED);
            if (disabledNode != null && disabledNode.asBoolean()) continue;
            String property = propertyNode.asText();
            Object value = SenchaFilterProcessor.extractValue(valueNode);
            boolean exactMatch = false;
            JsonNode exactMatchNode = filterNode.get(EXACT_MATCH);
            if (exactMatchNode != null) {
                exactMatch = exactMatchNode.asBoolean();
            }
            switch (operator = (operatorNode = filterNode.get(OPERATOR)) != null ? operatorNode.asText() : "like") {
                case "like": {
                    qualifier = this.like(property, value, exactMatch);
                    break;
                }
                case "=": {
                    qualifier = this.eq(property, value);
                    break;
                }
                case "!=": {
                    qualifier = this.neq(property, value);
                    break;
                }
                case ">": {
                    qualifier = this.gt(property, value);
                    break;
                }
                case ">=": {
                    qualifier = this.gte(property, value);
                    break;
                }
                case "<": {
                    qualifier = this.lt(property, value);
                    break;
                }
                case "<=": {
                    qualifier = this.lte(property, value);
                    break;
                }
                case "in": {
                    qualifier = this.in(property, value);
                    break;
                }
                default: {
                    throw new LinkRestException(Response.Status.BAD_REQUEST, "Invalid filter operator: " + operator);
                }
            }
            if (qualifier.getOperandCount() == 2) {
                this.pathCache.getPathDescriptor(entity, (ASTObjPath)qualifier.getOperand(0));
            }
            combined = combined != null ? combined.andExp(qualifier) : qualifier;
        }
        return this.postProcessor.process(entity, combined);
    }

    Expression eq(String property, Object value) {
        return ExpressionFactory.matchExp((String)property, (Object)value);
    }

    Expression neq(String property, Object value) {
        return ExpressionFactory.noMatchExp((String)property, (Object)value);
    }

    Expression like(String property, Object value, boolean exactMatch) {
        if (value == null || exactMatch || value instanceof Boolean) {
            return this.eq(property, value);
        }
        String string = value.toString();
        this.checkValueLength(string);
        string = FilterUtil.escapeValueForLike(string) + "%";
        return ExpressionFactory.likeIgnoreCaseExp((String)property, (Object)string);
    }

    Expression gt(String property, Object value) {
        return value == null ? ExpressionFactory.expFalse() : ExpressionFactory.greaterExp((String)property, (Object)value);
    }

    Expression gte(String property, Object value) {
        return value == null ? ExpressionFactory.expFalse() : ExpressionFactory.greaterOrEqualExp((String)property, (Object)value);
    }

    Expression lt(String property, Object value) {
        return value == null ? ExpressionFactory.expFalse() : ExpressionFactory.lessExp((String)property, (Object)value);
    }

    Expression lte(String property, Object value) {
        return value == null ? ExpressionFactory.expFalse() : ExpressionFactory.lessOrEqualExp((String)property, (Object)value);
    }

    Expression in(String property, Object value) {
        if (!(value instanceof List)) {
            return this.eq(property, value);
        }
        return ExpressionFactory.inExp((String)property, (Collection)((List)value));
    }

    private static Object extractValue(JsonNode valueNode) {
        JsonToken type = valueNode.asToken();
        switch (type) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_FALSE: {
                return false;
            }
            case VALUE_TRUE: {
                return true;
            }
            case VALUE_NUMBER_INT: {
                return valueNode.asInt();
            }
            case VALUE_NUMBER_FLOAT: {
                return valueNode.asDouble();
            }
            case START_ARRAY: {
                return SenchaFilterProcessor.extractArray(valueNode);
            }
        }
        return valueNode.asText();
    }

    private static List<Object> extractArray(JsonNode arrayNode) {
        ArrayList<Object> values = new ArrayList<Object>(arrayNode.size());
        for (JsonNode value : arrayNode) {
            values.add(SenchaFilterProcessor.extractValue(value));
        }
        return values;
    }

    private void checkValueLength(String value) {
        if (value.length() > 1024) {
            throw new LinkRestException(Response.Status.BAD_REQUEST, "filter 'value' is to long: " + value);
        }
    }
}

