/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime.adapter.sencha;

import com.fasterxml.jackson.core.JsonGenerator;
import com.nhl.link.rest.EntityProperty;
import com.nhl.link.rest.ResourceEntity;
import com.nhl.link.rest.encoder.CollectionEncoder;
import com.nhl.link.rest.encoder.DataResponseEncoder;
import com.nhl.link.rest.encoder.Encoder;
import com.nhl.link.rest.encoder.EncoderFilter;
import com.nhl.link.rest.encoder.GenericEncoder;
import com.nhl.link.rest.encoder.PropertyMetadataEncoder;
import com.nhl.link.rest.meta.LrRelationship;
import com.nhl.link.rest.runtime.adapter.sencha.SenchaEntityToOneEncoder;
import com.nhl.link.rest.runtime.encoder.EncoderService;
import com.nhl.link.rest.runtime.encoder.IAttributeEncoderFactory;
import com.nhl.link.rest.runtime.encoder.IStringConverterFactory;
import com.nhl.link.rest.runtime.semantics.IRelationshipMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.di.Inject;

public class SenchaEncoderService
extends EncoderService {
    public SenchaEncoderService(@Inject List<EncoderFilter> filters, @Inject IAttributeEncoderFactory attributeEncoderFactory, @Inject IStringConverterFactory stringConverterFactory, @Inject IRelationshipMapper relationshipMapper, @Inject Map<String, PropertyMetadataEncoder> propertyMetadataEncoders) {
        super(filters, attributeEncoderFactory, stringConverterFactory, relationshipMapper, propertyMetadataEncoders);
    }

    @Override
    public <T> Encoder dataEncoder(ResourceEntity<T> entity) {
        CollectionEncoder resultEncoder = this.resultEncoder(entity);
        return new DataResponseEncoder("data", resultEncoder, "total", GenericEncoder.encoder()){

            @Override
            protected void encodeObjectBody(Object object, JsonGenerator out) throws IOException {
                out.writeFieldName("success");
                out.writeBoolean(true);
                super.encodeObjectBody(object, out);
            }
        };
    }

    @Override
    protected Encoder toOneEncoder(ResourceEntity<?> resourceEntity, final LrRelationship relationship) {
        Encoder valueEncoder = this.entityEncoder(resourceEntity);
        EntityProperty idEncoder = this.attributeEncoderFactory.getIdProperty(resourceEntity);
        SenchaEntityToOneEncoder compositeValueEncoder = new SenchaEntityToOneEncoder(valueEncoder, idEncoder){
            final String idPropertyName;
            {
                super(objectEncoder, idEncoder);
                this.idPropertyName = SenchaEncoderService.this.relationshipMapper.toRelatedIdName(relationship);
            }

            @Override
            protected String idPropertyName(String propertyName) {
                return this.idPropertyName;
            }
        };
        return this.filteredEncoder(compositeValueEncoder, resourceEntity);
    }
}

