/*
 * Decompiled with CFR 0.152.
 */
package com.nhl.link.rest.runtime;

import com.nhl.link.rest.provider.EntityUpdateCollectionReader;
import com.nhl.link.rest.provider.EntityUpdateReader;
import com.nhl.link.rest.provider.ResponseStatusDynamicFeature;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkRestRuntime
implements Feature {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkRestRuntime.class);
    static final String LINK_REST_CONTAINER_PROPERTY = "linkrest.container";
    public static final String BODY_WRITERS_MAP = "linkrest.jaxrs.bodywriters";
    private Injector injector;
    private Collection<Class<?>> extraComponents;
    private Collection<Feature> extraFeatures;

    public static <T> T service(Class<T> type, Configuration config) {
        if (config == null) {
            throw new NullPointerException("Null config");
        }
        Injector injector = (Injector)config.getProperty(LINK_REST_CONTAINER_PROPERTY);
        if (injector == null) {
            throw new IllegalStateException("LinkRest is misconfigured. No injector found for property: linkrest.container");
        }
        return (T)injector.getInstance(type);
    }

    LinkRestRuntime(Injector injector, Collection<Feature> extraFeatures, Collection<Class<?>> extraComponents) {
        this.injector = injector;
        this.extraFeatures = extraFeatures;
        this.extraComponents = extraComponents;
    }

    public <T> T service(Class<T> type) {
        return (T)this.injector.getInstance(type);
    }

    public void shutdown() {
        LOGGER.info("Shutting down LinkRest");
        this.injector.shutdown();
    }

    public boolean configure(FeatureContext context) {
        context.property(LINK_REST_CONTAINER_PROPERTY, (Object)this.injector);
        Map bodyWriters = (Map)this.injector.getInstance(Key.getMapOf(String.class, Class.class, (String)BODY_WRITERS_MAP));
        for (Class clazz : bodyWriters.values()) {
            context.register(clazz);
        }
        context.register(ResponseStatusDynamicFeature.class);
        context.register(EntityUpdateReader.class);
        context.register(EntityUpdateCollectionReader.class);
        for (Class clazz : this.extraComponents) {
            context.register(clazz);
        }
        for (Feature feature : this.extraFeatures) {
            feature.configure(context);
        }
        return true;
    }
}

